/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.util;

import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.util.ICacheRecordGsonAdapter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonExtensions {
    private JsonExtensions() {
    }

    public static Map<String, String> extractJsonObjectIntoMap(String jsonString) throws JSONException {
        JSONObject jsonObject = new JSONObject(jsonString);
        Iterator keyIterator = jsonObject.keys();
        HashMap<String, String> responseItems = new HashMap<String, String>();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            responseItems.put(key, jsonObject.getString(key));
        }
        return responseItems;
    }

    public static List<ICacheRecord> getICacheRecordListFromJsonString(String accountJson) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter());
        Type listOfCacheRecords = new TypeToken<List<ICacheRecord>>(){}.getType();
        return (List)builder.create().fromJson(accountJson, listOfCacheRecords);
    }

    public static String getJsonStringFromICacheRecordList(List<ICacheRecord> cacheRecords) {
        Type listOfCacheRecords = new TypeToken<List<ICacheRecord>>(){}.getType();
        return new Gson().toJson(cacheRecords, listOfCacheRecords);
    }

    public static BrokerResult getBrokerResultFromJsonString(@NonNull String jsonString) {
        return (BrokerResult)new GsonBuilder().registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter()).create().fromJson(jsonString, BrokerResult.class);
    }
}

