/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.tokensharing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.adal.internal.tokensharing.TokenCacheItemSerializationAdapater;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class SSOStateSerializer {
    @SerializedName(value="version")
    private final int version = 1;
    @SerializedName(value="tokenCacheItems")
    private final List<ADALTokenCacheItem> mTokenCacheItems = new ArrayList<ADALTokenCacheItem>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ADALTokenCacheItem.class, (Object)new TokenCacheItemSerializationAdapater()).create();

    private SSOStateSerializer() {
    }

    private SSOStateSerializer(ADALTokenCacheItem item) {
        if (item == null) {
            throw new IllegalArgumentException("tokenItem is null");
        }
        this.mTokenCacheItems.add(item);
    }

    private int getVersion() {
        return 1;
    }

    private ADALTokenCacheItem getTokenItem() throws ClientException {
        if (this.mTokenCacheItems == null || this.mTokenCacheItems.isEmpty()) {
            throw new ClientException("token_cache_item_not_found", "There is no token cache item in the SSOStateContainer.");
        }
        return this.mTokenCacheItems.get(0);
    }

    private String internalSerialize() {
        return GSON.toJson((Object)this);
    }

    private ADALTokenCacheItem internalDeserialize(String serializedBlob) throws ClientException {
        try {
            JSONObject jsonObject = new JSONObject(serializedBlob);
            if (jsonObject.getInt("version") == this.getVersion()) {
                return ((SSOStateSerializer)GSON.fromJson(serializedBlob, SSOStateSerializer.class)).getTokenItem();
            }
            throw new ClientException("token_sharing_deserialization_error", "Fail to deserialize because the blob version is incompatible. The version of the serializedBlob is " + jsonObject.getInt("version") + ". And the target class version is " + this.getVersion());
        }
        catch (JsonParseException | JSONException exception) {
            throw new ClientException("token_sharing_deserialization_error", exception.getMessage());
        }
    }

    public static String serialize(ADALTokenCacheItem item) {
        SSOStateSerializer ssoStateSerializer = new SSOStateSerializer(item);
        return ssoStateSerializer.internalSerialize();
    }

    public static ADALTokenCacheItem deserialize(String serializedBlob) throws ClientException {
        SSOStateSerializer ssoStateSerializer = new SSOStateSerializer();
        return ssoStateSerializer.internalDeserialize(serializedBlob);
    }
}

