/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.BrokerAuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.BrowserAuthorizationFragment;
import com.microsoft.identity.common.internal.providers.oauth2.WebViewAuthorizationFragment;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.UiStartEvent;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.DualScreenActivity;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import java.io.Serializable;
import java.util.HashMap;

public class AuthorizationActivity
extends DualScreenActivity {
    private AuthorizationFragment mFragment;

    public static Intent createStartIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent, boolean webViewZoomEnabled, boolean webViewZoomControlsEnabled) {
        Intent intent = ProcessUtil.isBrokerProcess(context) ? new Intent(context, BrokerAuthorizationActivity.class) : new Intent(context, AuthorizationActivity.class){

            public Object clone() {
                return super.clone();
            }
        };
        intent.putExtra("com.microsoft.identity.auth.intent", (Parcelable)authIntent);
        intent.putExtra("com.microsoft.identity.request.url", requestUrl);
        intent.putExtra("com.microsoft.identity.request.redirect.uri", redirectUri);
        intent.putExtra("com.microsoft.identity.request.headers", requestHeaders);
        intent.putExtra("com.microsoft.identity.client.authorization.agent", (Serializable)((Object)authorizationAgent));
        intent.putExtra("com.microsoft.identity.web.view.zoom.controls.enabled", webViewZoomControlsEnabled);
        intent.putExtra("com.microsoft.identity.web.view.zoom.enabled", webViewZoomEnabled);
        intent.putExtra("correlation_id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        return intent;
    }

    public static AuthorizationFragment getAuthorizationFragmentFromStartIntent(@NonNull Intent intent) {
        AuthorizationAgent authorizationAgent = (AuthorizationAgent)((Object)intent.getSerializableExtra("com.microsoft.identity.client.authorization.agent"));
        Telemetry.emit(new UiStartEvent().putUserAgent(authorizationAgent));
        AuthorizationFragment fragment = authorizationAgent == AuthorizationAgent.WEBVIEW ? new WebViewAuthorizationFragment() : new BrowserAuthorizationFragment();
        fragment.setInstanceState(intent.getExtras());
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mFragment = AuthorizationActivity.getAuthorizationFragmentFromStartIntent(this.getIntent());
        this.setFragment(this.mFragment);
    }

    public void onBackPressed() {
        if (!this.mFragment.onBackPressed()) {
            super.onBackPressed();
        }
    }
}

