/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import android.text.TextUtils;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.platform.DevicePopManager;
import com.microsoft.identity.common.internal.platform.IDevicePopManager;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Device {
    private static IDevicePopManager sDevicePoPManager;
    public static final String PRODUCT_VERSION = "2.0.2";

    private Device() {
    }

    public static Map<String, String> getPlatformIdParameters() {
        HashMap<String, String> platformParameters = new HashMap<String, String>();
        if (Build.VERSION.SDK_INT < 21) {
            platformParameters.put("x-client-CPU", Build.CPU_ABI);
        } else {
            String[] supportedABIs = Build.SUPPORTED_ABIS;
            if (supportedABIs != null && supportedABIs.length > 0) {
                platformParameters.put("x-client-CPU", supportedABIs[0]);
            }
        }
        platformParameters.put("x-client-OS", String.valueOf(Build.VERSION.SDK_INT));
        platformParameters.put("x-client-DM", Build.MODEL);
        return Collections.unmodifiableMap(platformParameters);
    }

    public static String getProductVersion() {
        String version = (String)DiagnosticContext.getRequestContext().get("x-client-Ver");
        if (TextUtils.isEmpty((CharSequence)version)) {
            return PRODUCT_VERSION;
        }
        return version;
    }

    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static synchronized IDevicePopManager getDevicePoPManagerInstance() throws ClientException {
        try {
            if (null == sDevicePoPManager) {
                sDevicePoPManager = new DevicePopManager();
            }
            return sDevicePoPManager;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new ClientException("keystore_not_initialized", "Failed to initialize DevicePoPManager = " + e.getMessage(), e);
        }
    }

    public static final class PlatformIdParameters {
        public static final String CPU_PLATFORM = "x-client-CPU";
        public static final String OS = "x-client-OS";
        public static final String DEVICE_MODEL = "x-client-DM";
        public static final String BROKER_VERSION = "x-client-brkrver";
    }
}

