/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.microsoft.identity.common.internal.net.AbstractHttpClient;
import com.microsoft.identity.common.internal.net.HttpClient;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.internal.net.NoRetryPolicy;
import com.microsoft.identity.common.internal.net.RetryPolicy;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.HttpEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.HttpStartEvent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@Immutable
public class UrlConnectionHttpClient
extends AbstractHttpClient {
    private final RetryPolicy<HttpResponse> retryPolicy;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final Supplier<Integer> connectTimeoutMsSupplier;
    private final Supplier<Integer> readTimeoutMsSupplier;
    private final int streamBufferSize;
    private static transient AtomicReference<UrlConnectionHttpClient> defaultReference = new AtomicReference<Object>(null);

    public static <T> Supplier<T> supplierOf(final T value) {
        return new Supplier<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static UrlConnectionHttpClient getDefaultInstance() {
        UrlConnectionHttpClient reference = defaultReference.get();
        if (reference == null) {
            defaultReference.compareAndSet(null, UrlConnectionHttpClient.builder().build());
            reference = defaultReference.get();
        }
        return reference;
    }

    private static void recordHttpTelemetryEventStart(@NonNull String requestMethod, @NonNull URL requestUrl, @Nullable String requestId) {
        Telemetry.emit(new HttpStartEvent().putMethod(requestMethod).putPath(requestUrl).putRequestIdHeader(requestId));
    }

    private static void recordHttpTelemetryEventEnd(@Nullable HttpResponse response) {
        HttpEndEvent httpEndEvent = new HttpEndEvent();
        if (null != response) {
            httpEndEvent.putStatusCode(response.getStatusCode());
        }
        Telemetry.emit(httpEndEvent);
    }

    @Override
    public HttpResponse method(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        UrlConnectionHttpClient.recordHttpTelemetryEventStart(httpMethod.name(), requestUrl, requestHeaders.get("client-request-id"));
        final HttpRequest request = UrlConnectionHttpClient.constructHttpRequest(httpMethod, requestUrl, requestHeaders, requestContent);
        return this.retryPolicy.attempt(new Callable<HttpResponse>(){

            @Override
            public HttpResponse call() throws IOException {
                return UrlConnectionHttpClient.this.executeHttpSend(request, (Consumer<HttpResponse>)((Consumer)new Consumer<HttpResponse>(){

                    public void accept(HttpResponse httpResponse) {
                        UrlConnectionHttpClient.recordHttpTelemetryEventEnd(httpResponse);
                    }
                }));
            }
        });
    }

    private static HttpRequest constructHttpRequest(@NonNull HttpClient.HttpMethod httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) {
        if (HttpClient.HttpMethod.PATCH == httpMethod) {
            httpMethod = HttpClient.HttpMethod.POST;
            requestHeaders = new HashMap<String, String>(requestHeaders);
            requestHeaders.put("X-HTTP-Method-Override", HttpClient.HttpMethod.PATCH.name());
        }
        return new HttpRequest(requestUrl, requestHeaders, httpMethod.name(), requestContent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) throws IOException {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[this.streamBufferSize];
            StringBuilder stringBuilder = new StringBuilder();
            while ((charsRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(inputStream);
        }
    }

    private static void safeCloseStream(@Nullable Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpSend(HttpRequest request, Consumer<HttpResponse> completionCallback) throws IOException {
        HttpURLConnection urlConnection = this.setupConnection(request);
        urlConnection.setRequestMethod(request.getRequestMethod());
        urlConnection.setUseCaches(true);
        UrlConnectionHttpClient.setRequestBody(urlConnection, request.getRequestContent(), request.getmRequestHeaders().get("Content-Type"));
        InputStream responseStream = null;
        HttpResponse response = null;
        try {
            try {
                responseStream = urlConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw socketTimeoutException;
            }
            catch (IOException ioException) {
                responseStream = urlConnection.getErrorStream();
            }
            int statusCode = urlConnection.getResponseCode();
            Date date = new Date(urlConnection.getDate());
            String responseBody = responseStream == null ? "" : this.convertStreamToString(responseStream);
            response = new HttpResponse(date, statusCode, responseBody, urlConnection.getHeaderFields());
        }
        catch (Throwable throwable) {
            completionCallback.accept(response);
            UrlConnectionHttpClient.safeCloseStream(responseStream);
            throw throwable;
        }
        completionCallback.accept((Object)response);
        UrlConnectionHttpClient.safeCloseStream(responseStream);
        return response;
    }

    private HttpURLConnection setupConnection(HttpRequest request) throws IOException {
        HttpURLConnection urlConnection = HttpUrlConnectionFactory.createHttpURLConnection(request.getRequestUrl());
        Set<Map.Entry<String, String>> headerEntries = request.getmRequestHeaders().entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        urlConnection.setConnectTimeout(this.getConnectTimeoutMs());
        urlConnection.setReadTimeout(this.getReadTimeoutMs());
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    private Integer getReadTimeoutMs() {
        return this.readTimeoutMsSupplier == null ? this.readTimeoutMs : this.readTimeoutMsSupplier.get();
    }

    private Integer getConnectTimeoutMs() {
        return this.connectTimeoutMsSupplier == null ? this.connectTimeoutMs : this.connectTimeoutMsSupplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(@NonNull HttpURLConnection connection, @Nullable byte[] contentRequest, @Nullable String requestContentType) throws IOException {
        if (contentRequest == null) {
            return;
        }
        connection.setDoOutput(true);
        if (!StringUtil.isEmpty(requestContentType)) {
            connection.setRequestProperty("Content-Type", requestContentType);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(contentRequest.length));
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(contentRequest);
        }
        finally {
            UrlConnectionHttpClient.safeCloseStream(out);
        }
    }

    private static RetryPolicy<HttpResponse> $default$retryPolicy() {
        return new NoRetryPolicy();
    }

    private static int $default$connectTimeoutMs() {
        return 30000;
    }

    private static int $default$readTimeoutMs() {
        return 30000;
    }

    private static Supplier<Integer> $default$connectTimeoutMsSupplier() {
        return null;
    }

    private static Supplier<Integer> $default$readTimeoutMsSupplier() {
        return null;
    }

    private static int $default$streamBufferSize() {
        return 1024;
    }

    public static UrlConnectionHttpClientBuilder builder() {
        return new UrlConnectionHttpClientBuilder();
    }

    public UrlConnectionHttpClient(RetryPolicy<HttpResponse> retryPolicy, int connectTimeoutMs, int readTimeoutMs, Supplier<Integer> connectTimeoutMsSupplier, Supplier<Integer> readTimeoutMsSupplier, int streamBufferSize) {
        this.retryPolicy = retryPolicy;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.connectTimeoutMsSupplier = connectTimeoutMsSupplier;
        this.readTimeoutMsSupplier = readTimeoutMsSupplier;
        this.streamBufferSize = streamBufferSize;
    }

    public static class UrlConnectionHttpClientBuilder {
        private boolean retryPolicy$set;
        private RetryPolicy<HttpResponse> retryPolicy$value;
        private boolean connectTimeoutMs$set;
        private int connectTimeoutMs$value;
        private boolean readTimeoutMs$set;
        private int readTimeoutMs$value;
        private boolean connectTimeoutMsSupplier$set;
        private Supplier<Integer> connectTimeoutMsSupplier$value;
        private boolean readTimeoutMsSupplier$set;
        private Supplier<Integer> readTimeoutMsSupplier$value;
        private boolean streamBufferSize$set;
        private int streamBufferSize$value;

        UrlConnectionHttpClientBuilder() {
        }

        public UrlConnectionHttpClientBuilder retryPolicy(RetryPolicy<HttpResponse> retryPolicy) {
            this.retryPolicy$value = retryPolicy;
            this.retryPolicy$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs$value = connectTimeoutMs;
            this.connectTimeoutMs$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMs(int readTimeoutMs) {
            this.readTimeoutMs$value = readTimeoutMs;
            this.readTimeoutMs$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder connectTimeoutMsSupplier(Supplier<Integer> connectTimeoutMsSupplier) {
            this.connectTimeoutMsSupplier$value = connectTimeoutMsSupplier;
            this.connectTimeoutMsSupplier$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder readTimeoutMsSupplier(Supplier<Integer> readTimeoutMsSupplier) {
            this.readTimeoutMsSupplier$value = readTimeoutMsSupplier;
            this.readTimeoutMsSupplier$set = true;
            return this;
        }

        public UrlConnectionHttpClientBuilder streamBufferSize(int streamBufferSize) {
            this.streamBufferSize$value = streamBufferSize;
            this.streamBufferSize$set = true;
            return this;
        }

        public UrlConnectionHttpClient build() {
            RetryPolicy retryPolicy$value = this.retryPolicy$value;
            if (!this.retryPolicy$set) {
                retryPolicy$value = UrlConnectionHttpClient.$default$retryPolicy();
            }
            int connectTimeoutMs$value = this.connectTimeoutMs$value;
            if (!this.connectTimeoutMs$set) {
                connectTimeoutMs$value = UrlConnectionHttpClient.$default$connectTimeoutMs();
            }
            int readTimeoutMs$value = this.readTimeoutMs$value;
            if (!this.readTimeoutMs$set) {
                readTimeoutMs$value = UrlConnectionHttpClient.$default$readTimeoutMs();
            }
            Supplier connectTimeoutMsSupplier$value = this.connectTimeoutMsSupplier$value;
            if (!this.connectTimeoutMsSupplier$set) {
                connectTimeoutMsSupplier$value = UrlConnectionHttpClient.$default$connectTimeoutMsSupplier();
            }
            Supplier readTimeoutMsSupplier$value = this.readTimeoutMsSupplier$value;
            if (!this.readTimeoutMsSupplier$set) {
                readTimeoutMsSupplier$value = UrlConnectionHttpClient.$default$readTimeoutMsSupplier();
            }
            int streamBufferSize$value = this.streamBufferSize$value;
            if (!this.streamBufferSize$set) {
                streamBufferSize$value = UrlConnectionHttpClient.$default$streamBufferSize();
            }
            return new UrlConnectionHttpClient(retryPolicy$value, connectTimeoutMs$value, readTimeoutMs$value, connectTimeoutMsSupplier$value, readTimeoutMsSupplier$value, streamBufferSize$value);
        }

        public String toString() {
            return "UrlConnectionHttpClient.UrlConnectionHttpClientBuilder(retryPolicy$value=" + this.retryPolicy$value + ", connectTimeoutMs$value=" + this.connectTimeoutMs$value + ", readTimeoutMs$value=" + this.readTimeoutMs$value + ", connectTimeoutMsSupplier$value=" + this.connectTimeoutMsSupplier$value + ", readTimeoutMsSupplier$value=" + this.readTimeoutMsSupplier$value + ", streamBufferSize$value=" + this.streamBufferSize$value + ")";
        }
    }

    static interface Supplier<T> {
        public T get();
    }
}

