/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import com.microsoft.identity.common.internal.net.HttpClient;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.StatusCodeAndExceptionRetry;
import com.microsoft.identity.common.internal.net.UrlConnectionHttpClient;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class HttpRequest {
    private static final String HOST = "Host";
    @Deprecated
    public static int READ_TIMEOUT = 30000;
    @Deprecated
    public static int CONNECT_TIMEOUT = 30000;
    private static final int RETRY_TIME_WAITING_PERIOD_MSEC = 1000;
    private static final int STREAM_BUFFER_SIZE = 1024;
    private static final HttpClient DEFAULT_HTTP_CLIENT = UrlConnectionHttpClient.builder().connectTimeoutMsSupplier(new UrlConnectionHttpClient.Supplier<Integer>(){

        @Override
        public Integer get() {
            return CONNECT_TIMEOUT;
        }
    }).readTimeoutMsSupplier(new UrlConnectionHttpClient.Supplier<Integer>(){

        @Override
        public Integer get() {
            return READ_TIMEOUT;
        }
    }).streamBufferSize(1024).retryPolicy(new StatusCodeAndExceptionRetry.StatusCodeAndExceptionRetryBuilder().number(1).extensionFactor(2).isAcceptable(new Function<HttpResponse, Boolean>(){

        public Boolean apply(HttpResponse response) {
            return response != null && response.getStatusCode() < 400;
        }
    }).initialDelay(1000).isRetryable(new Function<HttpResponse, Boolean>(){

        public Boolean apply(HttpResponse response) {
            return response != null && HttpRequest.isRetryableError(response.getStatusCode());
        }
    }).isRetryableException(new Function<Exception, Boolean>(){

        public Boolean apply(Exception e) {
            return e instanceof SocketTimeoutException;
        }
    }).build()).build();
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_METHOD_HEAD = "HEAD";
    public static final String REQUEST_METHOD_PUT = "PUT";
    public static final String REQUEST_METHOD_DELETE = "DELETE";
    public static final String REQUEST_METHOD_TRACE = "TRACE";
    public static final String REQUEST_METHOD_OPTIONS = "OPTIONS";
    public static final String REQUEST_METHOD_PATCH = "PATCH";
    private static final Set<String> HTTP_METHODS = new LinkedHashSet<String>();
    private final URL mRequestUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final String mRequestMethod;
    private final Map<String, String> mRequestHeaders = new HashMap<String, String>();

    URL getRequestUrl() {
        return this.mRequestUrl;
    }

    byte[] getRequestContent() {
        return this.mRequestContent;
    }

    String getRequestContentType() {
        return this.mRequestContentType;
    }

    String getRequestMethod() {
        return this.mRequestMethod;
    }

    Map<String, String> getmRequestHeaders() {
        return Collections.unmodifiableMap(this.mRequestHeaders);
    }

    private HttpRequest(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @NonNull String requestMethod) {
        this(requestUrl, requestHeaders, requestMethod, null, null);
    }

    HttpRequest(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @NonNull String requestMethod, @Nullable byte[] requestContent, @Nullable String requestContentType) {
        this.mRequestUrl = requestUrl;
        this.mRequestHeaders.put(HOST, requestUrl.getAuthority());
        this.mRequestHeaders.putAll(requestHeaders);
        this.mRequestMethod = requestMethod;
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
    }

    @Deprecated
    public static HttpResponse sendPost(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent, @Nullable String requestContentType) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_POST, requestUrl, requestHeaders, requestContent, requestContentType);
    }

    @Deprecated
    public static HttpResponse sendGet(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_GET, requestUrl, requestHeaders, null, null);
    }

    @Deprecated
    public static HttpResponse sendHead(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_HEAD, requestUrl, requestHeaders, null, null);
    }

    @Deprecated
    public static HttpResponse sendPut(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent, @Nullable String requestContentType) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_PUT, requestUrl, requestHeaders, requestContent, requestContentType);
    }

    @Deprecated
    public static HttpResponse sendDelete(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent, @Nullable String requestContentType) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_DELETE, requestUrl, requestHeaders, requestContent, requestContentType);
    }

    @Deprecated
    public static HttpResponse sendTrace(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_TRACE, requestUrl, requestHeaders, null, null);
    }

    @Deprecated
    public static HttpResponse sendOptions(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_OPTIONS, requestUrl, requestHeaders, null, null);
    }

    @Deprecated
    public static HttpResponse sendPatch(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent, @Nullable String requestContentType) throws IOException {
        return HttpRequest.sendWithMethod(REQUEST_METHOD_PATCH, requestUrl, requestHeaders, requestContent, requestContentType);
    }

    @Deprecated
    public static HttpResponse sendWithMethod(@NonNull String httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent, @Nullable String requestContentType) throws IOException {
        HttpResponse response;
        Map<String, String> headerMap = requestHeaders;
        if (requestContentType != null) {
            headerMap = new LinkedHashMap<String, String>(headerMap);
            if (requestContentType != null) {
                headerMap.put("Content-Type", requestContentType);
            }
        }
        if ((response = DEFAULT_HTTP_CLIENT.method(httpMethod, requestUrl, headerMap, requestContent)) != null && HttpRequest.isRetryableError(response.getStatusCode())) {
            throw new UnknownServiceException("Retry failed again with 500/503/504");
        }
        return response;
    }

    private static boolean isRetryableError(int statusCode) {
        return statusCode == 500 || statusCode == 504 || statusCode == 503;
    }

    static {
        HTTP_METHODS.add(REQUEST_METHOD_GET);
        HTTP_METHODS.add(REQUEST_METHOD_POST);
        HTTP_METHODS.add(REQUEST_METHOD_HEAD);
        HTTP_METHODS.add(REQUEST_METHOD_PUT);
        HTTP_METHODS.add(REQUEST_METHOD_DELETE);
        HTTP_METHODS.add(REQUEST_METHOD_TRACE);
        HTTP_METHODS.add(REQUEST_METHOD_OPTIONS);
        HTTP_METHODS.add(REQUEST_METHOD_PATCH);
    }
}

