/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.content.Intent;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.adal.internal.IDeviceCertificate;
import com.microsoft.identity.common.adal.internal.JWSBuilder;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;

public final class PKeyAuthChallengeHandler
implements IChallengeHandler<PKeyAuthChallenge, Void> {
    private static final String TAG = PKeyAuthChallengeHandler.class.getSimpleName();
    private WebView mWebView;
    private IAuthorizationCompletionCallback mChallengeCallback;

    public PKeyAuthChallengeHandler(@NonNull WebView view, @NonNull IAuthorizationCompletionCallback completionCallback) {
        this.mWebView = view;
        this.mChallengeCallback = completionCallback;
    }

    @Override
    public Void processChallenge(final PKeyAuthChallenge pKeyAuthChallenge) {
        this.mWebView.stopLoading();
        this.mChallengeCallback.setPKeyAuthStatus(true);
        try {
            final Map<String, String> header = PKeyAuthChallengeHandler.getChallengeHeader(pKeyAuthChallenge);
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    String loadUrl = pKeyAuthChallenge.getSubmitUrl();
                    Logger.info(TAG, "Respond to pkeyAuth challenge");
                    Logger.infoPII(TAG, "Challenge submit url:" + pKeyAuthChallenge.getSubmitUrl());
                    PKeyAuthChallengeHandler.this.mWebView.loadUrl(loadUrl, header);
                }
            });
        }
        catch (ClientException e) {
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
            this.mChallengeCallback.onChallengeResponseReceived(2005, resultIntent);
        }
        return null;
    }

    public static Map<String, String> getChallengeHeader(PKeyAuthChallenge pKeyAuthChallenge) throws ClientException {
        IDeviceCertificate deviceCertProxy;
        String authorizationHeaderValue = String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", pKeyAuthChallenge.getContext(), pKeyAuthChallenge.getVersion());
        Class<IDeviceCertificate> certClazz = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        if (certClazz != null && ((deviceCertProxy = PKeyAuthChallengeHandler.getWPJAPIInstance(certClazz)).isValidIssuer(pKeyAuthChallenge.getCertAuthorities()) || StringUtil.equalsIgnoreCase(deviceCertProxy.getThumbPrint(), pKeyAuthChallenge.getThumbprint()))) {
            RSAPrivateKey privateKey = deviceCertProxy.getRSAPrivateKey();
            if (privateKey == null) {
                throw new ClientException("Key Chain private key exception");
            }
            String jwt = new JWSBuilder().generateSignedJWT(pKeyAuthChallenge.getNonce(), pKeyAuthChallenge.getSubmitUrl(), privateKey, deviceCertProxy.getRSAPublicKey(), deviceCertProxy.getCertificate());
            authorizationHeaderValue = String.format("%s AuthToken=\"%s\",Context=\"%s\",Version=\"%s\"", "PKeyAuth", jwt, pKeyAuthChallenge.getContext(), pKeyAuthChallenge.getVersion());
            Logger.info(TAG, "Receive challenge response. ");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", authorizationHeaderValue);
        return headers;
    }

    private static IDeviceCertificate getWPJAPIInstance(Class<IDeviceCertificate> certClazz) throws ClientException {
        IDeviceCertificate deviceCertProxy;
        try {
            Constructor<IDeviceCertificate> constructor = certClazz.getDeclaredConstructor(new Class[0]);
            deviceCertProxy = constructor.newInstance(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ClientException("Device certificate API has exception", "WPJ Api constructor is not defined", e);
        }
        return deviceCertProxy;
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint;

    }
}

