/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.migration;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.IMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenCacheItemMigrationAdapter;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdalMigrationAdapter
implements IMigrationAdapter<MicrosoftAccount, MicrosoftRefreshToken> {
    private static final Object sLock = new Object();
    private static final String TAG = AdalMigrationAdapter.class.getSimpleName();
    private static final String MIGRATION_STATUS_SHARED_PREFERENCES = "com.microsoft.identity.client.migration_status";
    private static final String KEY_MIGRATION_STATUS = "adal-migration-complete";
    private final SharedPreferences mSharedPrefs;
    private final boolean mForceMigration;
    private final Map<String, String> mRedirectsMap;

    public AdalMigrationAdapter(Context context, Map<String, String> redirects, boolean force) {
        this.mSharedPrefs = context.getSharedPreferences(MIGRATION_STATUS_SHARED_PREFERENCES, 0);
        this.mRedirectsMap = redirects;
        this.mForceMigration = force;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<MicrosoftAccount, MicrosoftRefreshToken>> adapt(Map<String, String> cacheItems) {
        ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>> result = new ArrayList<Pair<MicrosoftAccount, MicrosoftRefreshToken>>();
        Object object = sLock;
        synchronized (object) {
            boolean cloudMetadataLoaded;
            boolean hasMigrated = this.getMigrationStatus();
            if (!hasMigrated && !this.mForceMigration && (cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata())) {
                Map<String, ADALTokenCacheItem> nativeCacheItems = this.deserialize(cacheItems);
                result.addAll(TokenCacheItemMigrationAdapter.migrateTokens(this.mRedirectsMap, nativeCacheItems.values()));
                this.setMigrationStatus(true);
            }
        }
        return result;
    }

    @SuppressLint(value={"ApplySharedPref"})
    public void setMigrationStatus(boolean hasMigrated) {
        this.mSharedPrefs.edit().putBoolean(KEY_MIGRATION_STATUS, hasMigrated).commit();
    }

    public boolean getMigrationStatus() {
        return this.mSharedPrefs.getBoolean(KEY_MIGRATION_STATUS, false);
    }

    @Nullable
    public static MicrosoftAccount createAccount(@NonNull ADALTokenCacheItem refreshToken) {
        String methodName = ":createAccount";
        try {
            String rawIdToken = refreshToken.getRawIdToken();
            String uid = refreshToken.getUserInfo().getUserId();
            String utid = refreshToken.getTenantId();
            String environment = new URL(refreshToken.getAuthority()).getHost();
            JsonObject clientInfo = new JsonObject();
            clientInfo.addProperty("uid", uid);
            clientInfo.addProperty("utid", utid);
            String clientInfoJson = clientInfo.toString();
            String base64EncodedClientInfo = new String(Base64.encode((byte[])clientInfoJson.getBytes(), (int)0));
            ClientInfo clientInfoObj = new ClientInfo(base64EncodedClientInfo);
            IDToken idToken = new IDToken(rawIdToken);
            AzureActiveDirectoryAccount account = new AzureActiveDirectoryAccount(idToken, clientInfoObj);
            account.setEnvironment(environment);
            return account;
        }
        catch (ServiceException | MalformedURLException e) {
            String errorMsg = "Failed to create Account";
            Logger.error(TAG + ":createAccount", "Failed to create Account", null);
            Logger.errorPII(TAG + ":createAccount", "Failed to create Account", e);
            return null;
        }
    }

    @VisibleForTesting
    Map<String, ADALTokenCacheItem> deserialize(Map<String, String> tokenCacheItems) {
        HashMap<String, ADALTokenCacheItem> result = new HashMap<String, ADALTokenCacheItem>();
        Gson gson = new Gson();
        for (Map.Entry<String, String> entry : tokenCacheItems.entrySet()) {
            try {
                result.put(entry.getKey(), (ADALTokenCacheItem)gson.fromJson(entry.getValue(), ADALTokenCacheItem.class));
            }
            catch (JsonSyntaxException e) {
                Logger.warn(TAG, "Failed to deserialize ADAL cache entry. Skipping.");
            }
        }
        return result;
    }

    public static boolean loadCloudDiscoveryMetadata() {
        String methodName = ":loadCloudDiscoveryMetadata";
        if (!AzureActiveDirectory.isInitialized()) {
            try {
                AzureActiveDirectory.performCloudDiscovery();
            }
            catch (IOException e) {
                Logger.error(TAG + ":loadCloudDiscoveryMetadata", "Failed to load instance discovery metadata", e);
            }
        }
        return AzureActiveDirectory.isInitialized();
    }
}

