/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.eststelemetry.IRequestTelemetryCache;
import com.microsoft.identity.common.internal.eststelemetry.LastRequestTelemetry;
import com.microsoft.identity.common.internal.eststelemetry.RequestTelemetry;
import com.microsoft.identity.common.internal.logging.Logger;

public class SharedPreferencesLastRequestTelemetryCache
implements IRequestTelemetryCache {
    private static final String LAST_TELEMETRY_OBJECT_CACHE_KEY = "last_telemetry_object";
    private static final String LAST_TELEMETRY_HEADER_STRING_CACHE_KEY = "last_telemetry_header_string";
    private static final String LAST_TELEMETRY_SCHEMA_VERSION_CACHE_KEY = "last_telemetry_schema_version";
    private static final String TAG = SharedPreferencesLastRequestTelemetryCache.class.getSimpleName();
    private final Gson mGson;
    private final ISharedPreferencesFileManager mSharedPreferencesFileManager;

    SharedPreferencesLastRequestTelemetryCache(@NonNull ISharedPreferencesFileManager sharedPreferencesFileManager) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileManager = sharedPreferencesFileManager;
        this.mGson = new Gson();
    }

    ISharedPreferencesFileManager getSharedPreferencesFileManager() {
        return this.mSharedPreferencesFileManager;
    }

    @Override
    @Nullable
    public synchronized RequestTelemetry getRequestTelemetryFromCache() {
        String methodName = ":getRequestTelemetryFromCache";
        try {
            String cacheValue = this.mSharedPreferencesFileManager.getString(LAST_TELEMETRY_OBJECT_CACHE_KEY);
            if (cacheValue == null) {
                Logger.info(TAG + ":getRequestTelemetryFromCache", "There is no last request telemetry saved in the cache. Returning NULL");
                return null;
            }
            LastRequestTelemetry lastRequestTelemetry = (LastRequestTelemetry)this.mGson.fromJson(cacheValue, LastRequestTelemetry.class);
            if (lastRequestTelemetry == null) {
                Logger.warn(TAG + ":getRequestTelemetryFromCache", "Last Request Telemetry deserialization failed");
            }
            return lastRequestTelemetry;
        }
        catch (JsonSyntaxException e) {
            Logger.error(TAG + ":getRequestTelemetryFromCache", "Last Request Telemetry deserialization failed", e);
            return null;
        }
        catch (OutOfMemoryError e) {
            this.mSharedPreferencesFileManager.clear();
            throw e;
        }
    }

    @Override
    public synchronized void saveRequestTelemetryToCache(@NonNull RequestTelemetry requestTelemetry) {
        Logger.verbose(TAG, "Saving Last Request Telemetry to cache...");
        this.saveRequestTelemetryObjectToCache(requestTelemetry);
        this.saveTelemetryHeaderStringToCache(requestTelemetry);
        this.saveTelemetrySchemaVersionToCache(requestTelemetry);
    }

    private void saveRequestTelemetryObjectToCache(@NonNull RequestTelemetry requestTelemetry) {
        String cacheKey = LAST_TELEMETRY_OBJECT_CACHE_KEY;
        String cacheValue = this.generateCacheValue(requestTelemetry);
        this.saveToTelemetryCache(LAST_TELEMETRY_OBJECT_CACHE_KEY, cacheValue);
    }

    private void saveTelemetryHeaderStringToCache(@NonNull RequestTelemetry requestTelemetry) {
        String cacheKey = LAST_TELEMETRY_HEADER_STRING_CACHE_KEY;
        String cacheValue = requestTelemetry.getCompleteHeaderString();
        this.saveToTelemetryCache(LAST_TELEMETRY_HEADER_STRING_CACHE_KEY, cacheValue);
    }

    private void saveTelemetrySchemaVersionToCache(@NonNull RequestTelemetry requestTelemetry) {
        String cacheKey = LAST_TELEMETRY_SCHEMA_VERSION_CACHE_KEY;
        String cacheValue = requestTelemetry.getSchemaVersion();
        this.saveToTelemetryCache(LAST_TELEMETRY_SCHEMA_VERSION_CACHE_KEY, cacheValue);
    }

    private void saveToTelemetryCache(@NonNull String cacheKey, @NonNull String cacheValue) {
        this.mSharedPreferencesFileManager.putString(cacheKey, cacheValue);
    }

    private String generateCacheValue(RequestTelemetry requestTelemetry) {
        JsonElement outboundElement = this.mGson.toJsonTree((Object)requestTelemetry);
        JsonObject outboundObject = outboundElement.getAsJsonObject();
        String json = this.mGson.toJson((JsonElement)outboundObject);
        return json;
    }
}

