/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.ISendResultCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDisconnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;

public class UsbSmartcardCertBasedAuthChallengeHandler
extends AbstractSmartcardCertBasedAuthChallengeHandler<AbstractUsbSmartcardCertBasedAuthManager> {
    public UsbSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull AbstractUsbSmartcardCertBasedAuthManager usbSmartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        super(activity, usbSmartcardCertBasedAuthManager, dialogHolder, telemetryHelper, UsbSmartcardCertBasedAuthChallengeHandler.class.getSimpleName());
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).setConnectionCallback(new IConnectionCallback(){

            @Override
            public void onCreateConnection() {
                UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
            }
        });
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).setDisconnectionCallback(new IDisconnectionCallback(){

            @Override
            public void onClosedConnection() {
                if (UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.isDialogShowing()) {
                    UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.onUnexpectedUnplug();
                    if (!UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.isSmartcardRemovalPromptDialogShowing()) {
                        UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_early_unplug_dialog_title, R.string.smartcard_early_unplug_dialog_message);
                        Logger.verbose(UsbSmartcardCertBasedAuthChallengeHandler.this.TAG, "Smartcard was disconnected while dialog was still displayed.");
                    }
                }
            }
        });
    }

    @Override
    protected void prepForNextUserInteraction(@NonNull IDisconnectionCallback nextInteractionCallback) {
        nextInteractionCallback.onClosedConnection();
    }

    @Override
    protected void indicateDisconnectionError(@NonNull String methodName) {
        String methodTag = this.TAG + ":" + methodName;
        this.mDialogHolder.showErrorDialog(R.string.smartcard_early_unplug_dialog_title, R.string.smartcard_early_unplug_dialog_message);
        Logger.verbose(methodTag, "Smartcard was disconnected while dialog was still displayed.");
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).clearDisconnectionCallback();
    }

    @Override
    protected SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = this.TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            public void onClick(final @NonNull char[] pin) {
                ((AbstractUsbSmartcardCertBasedAuthManager)UsbSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

                    @Override
                    public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                        UsbSmartcardCertBasedAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, session);
                        UsbSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }

                    @Override
                    public void onException(@NonNull Exception e) {
                        UsbSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                        UsbSmartcardCertBasedAuthChallengeHandler.this.clearAllManagerCallbacks();
                        request.cancel();
                        UsbSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }
                });
            }
        };
    }

    @Override
    protected void setPinDialogForIncorrectAttempt(@NonNull ICertDetails certDetails, @NonNull ClientCertRequest request) {
        this.mDialogHolder.setPinDialogErrorMode();
    }

    @Override
    public void promptSmartcardRemovalForResult(final @NonNull ISendResultCallback callback) {
        if (((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).isDeviceConnected() && !((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).isUsbDeviceInitiallyPluggedIn()) {
            ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).setDisconnectionCallback(new IDisconnectionCallback(){

                @Override
                public void onClosedConnection() {
                    UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                    callback.onResultReady();
                }
            });
            this.mDialogHolder.showSmartcardRemovalPromptDialog(new IDismissCallback(){

                @Override
                public void onDismiss() {
                    callback.onResultReady();
                }
            });
            return;
        }
        callback.onResultReady();
    }

    @Override
    protected void clearAllManagerCallbacks() {
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).clearConnectionCallback();
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).clearDisconnectionCallback();
    }
}

