/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import androidx.credentials.exceptions.CreateCredentialCancellationException;
import androidx.credentials.exceptions.CreateCredentialInterruptedException;
import androidx.credentials.exceptions.CreateCredentialProviderConfigurationException;
import androidx.credentials.exceptions.CreateCredentialUnknownException;
import androidx.credentials.exceptions.GetCredentialCancellationException;
import androidx.credentials.exceptions.GetCredentialInterruptedException;
import androidx.credentials.exceptions.GetCredentialProviderConfigurationException;
import androidx.credentials.exceptions.GetCredentialUnknownException;
import androidx.credentials.exceptions.NoCredentialException;
import androidx.webkit.JavaScriptReplyProxy;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel;", "", "replyProxy", "Landroidx/webkit/JavaScriptReplyProxy;", "requestType", "", "spanContext", "Lio/opentelemetry/api/trace/SpanContext;", "(Landroidx/webkit/JavaScriptReplyProxy;Ljava/lang/String;Lio/opentelemetry/api/trace/SpanContext;)V", "postError", "", "throwable", "", "postSuccess", "json", "throwableToErrorMessage", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Error;", "Companion", "ReplyMessage", "common_distRelease"})
public final class PasskeyReplyChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JavaScriptReplyProxy replyProxy;
    @NotNull
    private final String requestType;
    @Nullable
    private final SpanContext spanContext;
    @NotNull
    public static final String TAG = "PasskeyReplyChannel";
    @NotNull
    public static final String STATUS_KEY = "status";
    @NotNull
    public static final String DATA_KEY = "data";
    @NotNull
    public static final String TYPE_KEY = "type";
    @NotNull
    public static final String DOM_EXCEPTION_MESSAGE_KEY = "domExceptionMessage";
    @NotNull
    public static final String DOM_EXCEPTION_NAME_KEY = "domExceptionName";
    @NotNull
    public static final String SUCCESS_STATUS = "success";
    @NotNull
    public static final String ERROR_STATUS = "error";
    @NotNull
    public static final String DOM_EXCEPTION_NOT_ALLOWED_ERROR = "NotAllowedError";
    @NotNull
    public static final String DOM_EXCEPTION_ABORT_ERROR = "AbortError";
    @NotNull
    public static final String DOM_EXCEPTION_NOT_SUPPORTED_ERROR = "NotSupportedError";
    @NotNull
    public static final String DOM_EXCEPTION_UNKNOWN_ERROR = "UnknownError";

    public PasskeyReplyChannel(@NotNull JavaScriptReplyProxy replyProxy, @NotNull String requestType, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)replyProxy, (String)"replyProxy");
        Intrinsics.checkNotNullParameter((Object)requestType, (String)"requestType");
        this.replyProxy = replyProxy;
        this.requestType = requestType;
        this.spanContext = spanContext;
    }

    public /* synthetic */ PasskeyReplyChannel(JavaScriptReplyProxy javaScriptReplyProxy, String string2, SpanContext spanContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "unknown";
        }
        if ((n & 4) != 0) {
            spanContext = null;
        }
        this(javaScriptReplyProxy, string2, spanContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RequiresFeature", "Only called when feature is available"})
    public final void postSuccess(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String methodTag = "PasskeyReplyChannel:postSuccess";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.PasskeyWebListener.name(), (SpanContext)this.spanContext);
        try {
            AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)span2);
            Throwable throwable = null;
            try {
                Scope it = (Scope)autoCloseable;
                boolean bl = false;
                String successMessage = new ReplyMessage.Success(json, this.requestType).toString();
                this.replyProxy.postMessage(successMessage);
                Logger.info(methodTag, "RequestType: " + this.requestType + " was successful.");
                span2.setAttribute(AttributeName.passkey_operation_type.name(), this.requestType);
                Span span3 = span2.setStatus(StatusCode.OK);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable throwable) {
            span2.setStatus(StatusCode.ERROR);
            span2.setAttribute(AttributeName.passkey_operation_type.name(), this.requestType);
            span2.recordException(throwable);
            Logger.error(methodTag, "Reply message failed", throwable);
            throw throwable;
        }
        finally {
            span2.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RequiresFeature", "Only called when feature is available"})
    public final void postError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        String methodTag = "PasskeyReplyChannel:postError";
        Span span2 = OTelUtility.createSpanFromParent((String)SpanName.PasskeyWebListener.name(), (SpanContext)this.spanContext);
        try {
            AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)span2);
            Throwable throwable2 = null;
            try {
                Scope it = (Scope)autoCloseable;
                boolean bl = false;
                ReplyMessage.Error errorMessage = this.throwableToErrorMessage(throwable);
                this.replyProxy.postMessage(errorMessage.toString());
                span2.setAttribute(AttributeName.passkey_operation_type.name(), this.requestType);
                span2.setAttribute(AttributeName.passkey_dom_exception_name.name(), errorMessage.getDomExceptionName());
                span2.setStatus(StatusCode.ERROR);
                span2.recordException(throwable);
                Logger.error(methodTag, "RequestType: " + this.requestType + " failed with error: " + errorMessage, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
        catch (Throwable unexpectedException) {
            span2.setStatus(StatusCode.ERROR);
            span2.recordException(unexpectedException);
            span2.setAttribute(AttributeName.passkey_operation_type.name(), this.requestType);
            Logger.error(methodTag, "Reply message failed", unexpectedException);
            throw unexpectedException;
        }
        finally {
            span2.end();
        }
    }

    private final ReplyMessage.Error throwableToErrorMessage(Throwable throwable) {
        Throwable throwable2;
        String errorMessage;
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = errorMessage = "Unknown error (empty message)";
        }
        String exceptionName = (((throwable2 = throwable) instanceof CreateCredentialCancellationException ? true : throwable2 instanceof GetCredentialCancellationException) ? true : throwable2 instanceof NoCredentialException) ? DOM_EXCEPTION_NOT_ALLOWED_ERROR : ((throwable2 instanceof CreateCredentialInterruptedException ? true : throwable2 instanceof GetCredentialInterruptedException) ? DOM_EXCEPTION_ABORT_ERROR : ((throwable2 instanceof CreateCredentialProviderConfigurationException ? true : throwable2 instanceof GetCredentialProviderConfigurationException) ? DOM_EXCEPTION_NOT_SUPPORTED_ERROR : ((throwable2 instanceof CreateCredentialUnknownException ? true : throwable2 instanceof GetCredentialUnknownException) ? DOM_EXCEPTION_UNKNOWN_ERROR : DOM_EXCEPTION_NOT_ALLOWED_ERROR)));
        return new ReplyMessage.Error(errorMessage, exceptionName, this.requestType);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\bH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage;", "", "()V", "data", "Lorg/json/JSONObject;", "getData", "()Lorg/json/JSONObject;", "status", "", "getStatus", "()Ljava/lang/String;", "type", "getType", "toString", "Error", "Success", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Error;", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Success;", "common_distRelease"})
    public static abstract class ReplyMessage {
        private ReplyMessage() {
        }

        @NotNull
        public abstract String getType();

        @NotNull
        public abstract String getStatus();

        @NotNull
        public abstract JSONObject getData();

        @NotNull
        public String toString() {
            JSONObject jSONObject;
            JSONObject $this$toString_u24lambda_u240 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$toString_u24lambda_u240.put(PasskeyReplyChannel.STATUS_KEY, (Object)this.getStatus());
            $this$toString_u24lambda_u240.put(PasskeyReplyChannel.DATA_KEY, (Object)this.getData());
            $this$toString_u24lambda_u240.put(PasskeyReplyChannel.TYPE_KEY, (Object)this.getType());
            String string2 = jSONObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject().apply {\n   \u2026\n            }.toString()");
            return string2;
        }

        public /* synthetic */ ReplyMessage(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Success;", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage;", "json", "", "type", "(Ljava/lang/String;Ljava/lang/String;)V", "data", "Lorg/json/JSONObject;", "getData", "()Lorg/json/JSONObject;", "getJson", "()Ljava/lang/String;", "status", "getStatus", "getType", "common_distRelease"})
        @SourceDebugExtension(value={"SMAP\nPasskeyReplyChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasskeyReplyChannel.kt\ncom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Success\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
        public static final class Success
        extends ReplyMessage {
            @NotNull
            private final String json;
            @NotNull
            private final String type;
            @NotNull
            private final String status;
            @NotNull
            private final JSONObject data;

            public Success(@NotNull String json, @NotNull String type) {
                Object object;
                Object $this$data_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)type, (String)PasskeyReplyChannel.TYPE_KEY);
                super(null);
                this.json = json;
                this.type = type;
                this.status = PasskeyReplyChannel.SUCCESS_STATUS;
                Object object2 = this;
                Success success = this;
                try {
                    $this$data_u24lambda_u240 = object2;
                    boolean bl = false;
                    $this$data_u24lambda_u240 = Result.constructor-impl((Object)new JSONObject(((Success)$this$data_u24lambda_u240).json));
                }
                catch (Throwable bl) {
                    $this$data_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                Success success2 = success;
                object2 = $this$data_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    object = object2;
                } else {
                    $this$data_u24lambda_u240 = throwable;
                    success = success2;
                    boolean bl = false;
                    object = new JSONObject();
                    success2 = success;
                }
                success2.data = (JSONObject)object;
            }

            @NotNull
            public final String getJson() {
                return this.json;
            }

            @Override
            @NotNull
            public String getType() {
                return this.type;
            }

            @Override
            @NotNull
            public String getStatus() {
                return this.status;
            }

            @Override
            @NotNull
            public JSONObject getData() {
                return this.data;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage$Error;", "Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$ReplyMessage;", "domExceptionMessage", "", "domExceptionName", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "data", "Lorg/json/JSONObject;", "getData", "()Lorg/json/JSONObject;", "getDomExceptionMessage", "()Ljava/lang/String;", "getDomExceptionName", "status", "getStatus", "getType", "common_distRelease"})
        public static final class Error
        extends ReplyMessage {
            @NotNull
            private final String domExceptionMessage;
            @NotNull
            private final String domExceptionName;
            @NotNull
            private final String type;
            @NotNull
            private final String status;

            public Error(@NotNull String domExceptionMessage, @NotNull String domExceptionName, @NotNull String type) {
                Intrinsics.checkNotNullParameter((Object)domExceptionMessage, (String)PasskeyReplyChannel.DOM_EXCEPTION_MESSAGE_KEY);
                Intrinsics.checkNotNullParameter((Object)domExceptionName, (String)PasskeyReplyChannel.DOM_EXCEPTION_NAME_KEY);
                Intrinsics.checkNotNullParameter((Object)type, (String)PasskeyReplyChannel.TYPE_KEY);
                super(null);
                this.domExceptionMessage = domExceptionMessage;
                this.domExceptionName = domExceptionName;
                this.type = type;
                this.status = PasskeyReplyChannel.ERROR_STATUS;
            }

            public /* synthetic */ Error(String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string3 = PasskeyReplyChannel.DOM_EXCEPTION_NOT_ALLOWED_ERROR;
                }
                this(string2, string3, string4);
            }

            @NotNull
            public final String getDomExceptionMessage() {
                return this.domExceptionMessage;
            }

            @NotNull
            public final String getDomExceptionName() {
                return this.domExceptionName;
            }

            @Override
            @NotNull
            public String getType() {
                return this.type;
            }

            @Override
            @NotNull
            public String getStatus() {
                return this.status;
            }

            @Override
            @NotNull
            public JSONObject getData() {
                JSONObject jSONObject;
                JSONObject $this$_get_data__u24lambda_u240 = jSONObject = new JSONObject();
                boolean bl = false;
                $this$_get_data__u24lambda_u240.put(PasskeyReplyChannel.DOM_EXCEPTION_MESSAGE_KEY, (Object)this.domExceptionMessage);
                $this$_get_data__u24lambda_u240.put(PasskeyReplyChannel.DOM_EXCEPTION_NAME_KEY, (Object)this.domExceptionName);
                return jSONObject;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/microsoft/identity/common/internal/providers/oauth2/PasskeyReplyChannel$Companion;", "", "()V", "DATA_KEY", "", "DOM_EXCEPTION_ABORT_ERROR", "DOM_EXCEPTION_MESSAGE_KEY", "DOM_EXCEPTION_NAME_KEY", "DOM_EXCEPTION_NOT_ALLOWED_ERROR", "DOM_EXCEPTION_NOT_SUPPORTED_ERROR", "DOM_EXCEPTION_UNKNOWN_ERROR", "ERROR_STATUS", "STATUS_KEY", "SUCCESS_STATUS", "TAG", "TYPE_KEY", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

