/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivityFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationFragment;
import com.microsoft.identity.common.internal.ui.DualScreenActivity;
import com.microsoft.identity.common.internal.util.CommonMoshiJsonAdapter;
import com.microsoft.identity.common.java.exception.TerminalException;
import com.microsoft.identity.common.java.opentelemetry.SerializableSpanContext;
import com.microsoft.identity.common.java.opentelemetry.TextMapPropagatorExtension;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationActivity
extends DualScreenActivity {
    public static final String TAG = AuthorizationActivity.class.getSimpleName();
    private SpanContext mSpanContext;
    private Context mOtelContext;
    private AuthorizationFragment mFragment;

    public AuthorizationFragment getFragment() {
        return this.mFragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        Fragment fragment;
        super.onCreate(savedInstanceState);
        String methodTag = TAG + ":onCreate";
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            try {
                String spanContextJson = bundle.getString("serializable_span_context");
                this.mSpanContext = StringUtil.isNullOrEmpty((String)spanContextJson) ? null : (SpanContext)new CommonMoshiJsonAdapter().fromJson(spanContextJson, SerializableSpanContext.class);
                HashMap carrier = Build.VERSION.SDK_INT >= 33 ? (HashMap)bundle.getSerializable("otel_context_carrier", HashMap.class) : (HashMap)bundle.getSerializable("otel_context_carrier");
                this.mOtelContext = TextMapPropagatorExtension.extract((Map)carrier);
            }
            catch (TerminalException | ClassCastException | NullPointerException e) {
                Logger.error(methodTag, "Exception thrown during extraction: " + e.getMessage(), e);
            }
        }
        if ((fragment = AuthorizationActivityFactory.getAuthorizationFragmentFromStartIntent(this.getIntent())) instanceof AuthorizationFragment) {
            this.mFragment = (AuthorizationFragment)fragment;
            this.mFragment.setInstanceState(bundle);
        } else {
            IllegalStateException ex = new IllegalStateException("Unexpected fragment type.");
            Logger.error(methodTag, "Did not receive AuthorizationFragment from factory", ex);
        }
        this.setFragment(this.mFragment);
    }

    public SpanContext getSpanContext() {
        return this.mSpanContext;
    }

    public Context getOtelContext() {
        return this.mOtelContext;
    }
}

