/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.logging.Logger;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\u0016\u0010\u0017\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/internal/cache/WebAppsAccountIdRegistry;", "", "storage", "Lcom/microsoft/identity/common/java/cache/IMultiTypeNameValueStorage;", "(Lcom/microsoft/identity/common/java/cache/IMultiTypeNameValueStorage;)V", "addClient", "", "homeAccountId", "", "clientId", "contains", "", "deserializeSet", "", "raw", "getClients", "", "loadClientIdsForAccount", "removeAccount", "removeAccountStorage", "removeClient", "saveAccount", "set", "serializeSet", "Companion", "common_distRelease"})
public final class WebAppsAccountIdRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IMultiTypeNameValueStorage storage;
    private static final String TAG = WebAppsAccountIdRegistry.class.getSimpleName();
    @NotNull
    private static final String WEBAPPS_ACCOUNT_ID_REGISTRY_STORAGE_KEY = "WebAppsAccountIdRegistryStorageKey";
    @NotNull
    private static final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    private WebAppsAccountIdRegistry(IMultiTypeNameValueStorage storage) {
        this.storage = storage;
    }

    private final Set<String> deserializeSet(String raw) {
        Object object = raw;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return new LinkedHashSet();
        }
        try {
            Object object2 = ObjectMapper.deserializeJsonStringToObject((String)raw, String[].class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"deserializeJsonStringToO\u2026rray<String>::class.java)");
            object = ArraysKt.toMutableSet((Object[])((Object[])object2));
        }
        catch (Exception e) {
            Logger.warn(TAG, "Failed to deserialize set: " + e.getMessage());
            object = new LinkedHashSet();
        }
        return object;
    }

    private final String serializeSet(Set<String> set) {
        String string = ObjectMapper.serializeObjectToJsonString(set);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serializeObjectToJsonString(set)");
        return string;
    }

    private final Set<String> loadClientIdsForAccount(String homeAccountId) {
        return this.deserializeSet(this.storage.getString(homeAccountId));
    }

    private final void saveAccount(String homeAccountId, Set<String> set) {
        this.storage.putString(homeAccountId, this.serializeSet(set));
    }

    private final void removeAccountStorage(String homeAccountId) {
        try {
            this.storage.remove(homeAccountId);
        }
        catch (Exception e) {
            this.storage.putString(homeAccountId, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClient(@NotNull String homeAccountId, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)homeAccountId, (String)"homeAccountId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ReentrantReadWriteLock reentrantReadWriteLock = rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Set<String> set = this.loadClientIdsForAccount(homeAccountId);
            if (set.add(clientId)) {
                this.saveAccount(homeAccountId, set);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeClient(@NotNull String homeAccountId, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)homeAccountId, (String)"homeAccountId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ReentrantReadWriteLock reentrantReadWriteLock = rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Set<String> set = this.loadClientIdsForAccount(homeAccountId);
            if (!set.remove(clientId)) {
                return;
            }
            if (set.isEmpty()) {
                this.removeAccountStorage(homeAccountId);
            } else {
                this.saveAccount(homeAccountId, set);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int set = 0; set < n; ++set) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<String> getClients(@NotNull String homeAccountId) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)homeAccountId, (String)"homeAccountId");
        ReentrantReadWriteLock.ReadLock readLock = rwLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            set = CollectionsKt.toSet((Iterable)this.loadClientIdsForAccount(homeAccountId));
        }
        finally {
            readLock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(@NotNull String homeAccountId, @NotNull String clientId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)homeAccountId, (String)"homeAccountId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        ReentrantReadWriteLock.ReadLock readLock = rwLock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.loadClientIdsForAccount(homeAccountId).contains(clientId);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAccount(@NotNull String homeAccountId) {
        Intrinsics.checkNotNullParameter((Object)homeAccountId, (String)"homeAccountId");
        ReentrantReadWriteLock reentrantReadWriteLock = rwLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Set<String> set = this.loadClientIdsForAccount(homeAccountId);
            if (set.isEmpty()) {
                return;
            }
            this.removeAccountStorage(homeAccountId);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int set = 0; set < n; ++set) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @JvmStatic
    @NotNull
    public static final WebAppsAccountIdRegistry create(@NotNull IStorageSupplier supplier) {
        return Companion.create(supplier);
    }

    public /* synthetic */ WebAppsAccountIdRegistry(IMultiTypeNameValueStorage storage, DefaultConstructorMarker $constructor_marker) {
        this(storage);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/cache/WebAppsAccountIdRegistry$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "WEBAPPS_ACCOUNT_ID_REGISTRY_STORAGE_KEY", "rwLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "create", "Lcom/microsoft/identity/common/internal/cache/WebAppsAccountIdRegistry;", "supplier", "Lcom/microsoft/identity/common/java/interfaces/IStorageSupplier;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final WebAppsAccountIdRegistry create(@NotNull IStorageSupplier supplier) {
            Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
            IMultiTypeNameValueStorage store = supplier.getEncryptedFileStore(WebAppsAccountIdRegistry.WEBAPPS_ACCOUNT_ID_REGISTRY_STORAGE_KEY);
            return new WebAppsAccountIdRegistry(store, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

