/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto.wrappedsecretkey;

import com.microsoft.identity.common.crypto.wrappedsecretkey.AbstractWrappedSecretKeySerializer;
import com.microsoft.identity.common.crypto.wrappedsecretkey.IWrappedSecretKeySerializer;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKeyBinaryStreamSerializer;
import com.microsoft.identity.common.crypto.wrappedsecretkey.WrappedSecretKeyLegacySerializer;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/common/crypto/wrappedsecretkey/WrappedSecretKeySerializerManager;", "", "()V", "TAG", "", "getSerializer", "Lcom/microsoft/identity/common/crypto/wrappedsecretkey/IWrappedSecretKeySerializer;", "serializerId", "", "identifySerializer", "wrappedSecretKeyByteArray", "", "common_distRelease"})
public final class WrappedSecretKeySerializerManager {
    @NotNull
    public static final WrappedSecretKeySerializerManager INSTANCE = new WrappedSecretKeySerializerManager();
    @NotNull
    private static final String TAG = "WrappedSecretKeySerializerManager";

    private WrappedSecretKeySerializerManager() {
    }

    public final int identifySerializer(@NotNull byte[] wrappedSecretKeyByteArray) {
        Intrinsics.checkNotNullParameter((Object)wrappedSecretKeyByteArray, (String)"wrappedSecretKeyByteArray");
        String methodTag = "WrappedSecretKeySerializerManager:identifySerializer";
        Integer serializerId = AbstractWrappedSecretKeySerializer.Companion.getSerializerIdFromByteArray(wrappedSecretKeyByteArray);
        Logger.info(methodTag, "Detected serializer ID: " + serializerId);
        Integer n = serializerId;
        return n != null ? n : 0;
    }

    @NotNull
    public final IWrappedSecretKeySerializer getSerializer(int serializerId) {
        IWrappedSecretKeySerializer iWrappedSecretKeySerializer;
        String methodTag = "WrappedSecretKeySerializerManager:getSerializer";
        Logger.info(methodTag, "Getting serializer for ID: " + serializerId);
        switch (serializerId) {
            case 1: {
                iWrappedSecretKeySerializer = new WrappedSecretKeyBinaryStreamSerializer();
                break;
            }
            case 0: {
                iWrappedSecretKeySerializer = new WrappedSecretKeyLegacySerializer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported serializer ID: " + serializerId);
            }
        }
        return iWrappedSecretKeySerializer;
    }
}

