/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;

public abstract class AbstractCertBasedAuthChallengeHandler
implements IChallengeHandler<ClientCertRequest, Void> {
    protected boolean mIsCertBasedAuthProceeding;
    protected ICertBasedAuthTelemetryHelper mTelemetryHelper;

    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (!this.mIsCertBasedAuthProceeding) {
            return;
        }
        RawAuthorizationResult.ResultCode resultCode = response.getResultCode();
        if (resultCode == RawAuthorizationResult.ResultCode.NON_OAUTH_ERROR || resultCode == RawAuthorizationResult.ResultCode.SDK_CANCELLED || resultCode == RawAuthorizationResult.ResultCode.CANCELLED) {
            BaseException exception = response.getException();
            if (exception != null) {
                this.mTelemetryHelper.setResultFailure((Exception)((Object)exception));
                return;
            }
            this.mTelemetryHelper.setResultFailure(resultCode.toString());
            return;
        }
        this.mTelemetryHelper.setResultSuccess();
    }

    public abstract void cleanUp();
}

