/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.IBrokerValidator;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBo\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00126\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0005\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp;", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "accountTypeForEachPackage", "", "", "sendRequestViaAccountManager", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "accountType", "Landroid/os/Bundle;", "bundle", "getAccountManagerApps", "Lkotlin/Function0;", "", "Landroid/accounts/AuthenticatorDescription;", "brokerValidator", "Lcom/microsoft/identity/common/internal/broker/IBrokerValidator;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lcom/microsoft/identity/common/internal/broker/IBrokerValidator;)V", "communicateToBroker", "Lcom/microsoft/identity/common/internal/broker/ipc/BrokerOperationBundle;", "getType", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy$Type;", "isSupportedByTargetedBroker", "", "targetedBrokerPackageName", "validateTargetApp", "", "targetPackageName", "Companion", "common_distRelease"})
public final class AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp
implements IIpcStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> accountTypeForEachPackage;
    @NotNull
    private final Function2<String, Bundle, Bundle> sendRequestViaAccountManager;
    @NotNull
    private final Function0<AuthenticatorDescription[]> getAccountManagerApps;
    @NotNull
    private final IBrokerValidator brokerValidator;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.class).getSimpleName();
    @NotNull
    public static final String CONTENT_PROVIDER_PATH_KEY = "CONTENT_PROVIDER_PATH";
    @NotNull
    public static final String REQUEST_BUNDLE_KEY = "REQUEST_BUNDLE";
    @NotNull
    public static final String LTW_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE = "com.microsoft.ltwpassthroughbackup";
    @NotNull
    public static final String CP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE = "com.microsoft.cppassthroughbackup";
    @NotNull
    public static final String AUTHAPP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE = "com.microsoft.authapppassthroughbackup";

    public AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp(@NotNull Map<String, String> accountTypeForEachPackage, @NotNull Function2<? super String, ? super Bundle, Bundle> sendRequestViaAccountManager, @NotNull Function0<AuthenticatorDescription[]> getAccountManagerApps, @NotNull IBrokerValidator brokerValidator) {
        Intrinsics.checkNotNullParameter(accountTypeForEachPackage, (String)"accountTypeForEachPackage");
        Intrinsics.checkNotNullParameter(sendRequestViaAccountManager, (String)"sendRequestViaAccountManager");
        Intrinsics.checkNotNullParameter(getAccountManagerApps, (String)"getAccountManagerApps");
        Intrinsics.checkNotNullParameter((Object)brokerValidator, (String)"brokerValidator");
        this.accountTypeForEachPackage = accountTypeForEachPackage;
        this.sendRequestViaAccountManager = sendRequestViaAccountManager;
        this.getAccountManagerApps = getAccountManagerApps;
        this.brokerValidator = brokerValidator;
    }

    @Override
    @Nullable
    public Bundle communicateToBroker(@NotNull BrokerOperationBundle bundle) throws BrokerCommunicationException {
        Bundle bundle2;
        Bundle bundle32;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        String methodTag = TAG + ":communicateToBroker";
        String string = bundle.targetBrokerAppPackageName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.targetBrokerAppPackageName");
        String targetPackageName = string;
        String string2 = this.accountTypeForEachPackage.get(targetPackageName);
        if (string2 == null) {
            boolean bundle32 = false;
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, this.getType(), "AccountManagerBackupIpcStrategy doesn't recognize " + targetPackageName + " as a broker", null);
        }
        String accountType = string2;
        this.validateTargetApp(targetPackageName, accountType);
        Bundle $this$communicateToBroker_u24lambda_u241 = bundle32 = new Bundle();
        boolean bl = false;
        $this$communicateToBroker_u24lambda_u241.putParcelable(REQUEST_BUNDLE_KEY, (Parcelable)bundle.bundle);
        $this$communicateToBroker_u24lambda_u241.putString(CONTENT_PROVIDER_PATH_KEY, bundle.operation.getContentApi().getPath());
        Bundle requestBundle = bundle32;
        try {
            Bundle result;
            bundle2 = result = (Bundle)this.sendRequestViaAccountManager.invoke((Object)accountType, (Object)requestBundle);
        }
        catch (Throwable e) {
            CharSequence charSequence = e.getMessage();
            String errorMessage = charSequence == null || charSequence.length() == 0 ? e.getClass().getSimpleName() + " is thrown" : e.getMessage();
            Logger.error(methodTag, errorMessage, e);
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.CONNECTION_ERROR, this.getType(), "AccountManager failed to respond - " + errorMessage, e);
        }
        return bundle2;
    }

    @Override
    public boolean isSupportedByTargetedBroker(@NotNull String targetedBrokerPackageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)targetedBrokerPackageName, (String)"targetedBrokerPackageName");
        String methodTag = TAG + ":isSupportedByTargetedBroker";
        try {
            String string = this.accountTypeForEachPackage.get(targetedBrokerPackageName);
            if (string == null) {
                boolean bl2 = false;
                Logger.info(methodTag, "AccountManagerBackupIpcStrategy doesn't recognize " + targetedBrokerPackageName + " as a broker");
                return false;
            }
            String accountType = string;
            this.validateTargetApp(targetedBrokerPackageName, accountType);
            bl = true;
        }
        catch (Throwable t) {
            Logger.error(methodTag, t.getMessage(), t);
            bl = false;
        }
        return bl;
    }

    private final void validateTargetApp(String targetPackageName, String accountType) throws BrokerCommunicationException {
        AuthenticatorDescription authenticatorDescription;
        try {
            Object element$iv2;
            block5: {
                Object[] $this$first$iv = (Object[])this.getAccountManagerApps.invoke();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    AuthenticatorDescription it = (AuthenticatorDescription)element$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.packageName, (Object)targetPackageName) && Intrinsics.areEqual((Object)it.type, (Object)accountType))) {
                        continue;
                    }
                    break block5;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            authenticatorDescription = (AuthenticatorDescription)element$iv2;
        }
        catch (Throwable t) {
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.VALIDATION_ERROR, this.getType(), targetPackageName + " doesn't support account manager backup ipc.", null);
        }
        AuthenticatorDescription targetAppInfo = authenticatorDescription;
        String string = targetAppInfo.packageName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetAppInfo.packageName");
        if (!this.brokerValidator.isValidBrokerPackage(string)) {
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.VALIDATION_ERROR, this.getType(), targetAppInfo.packageName + " is not a valid broker app.", null);
        }
    }

    @Override
    @NotNull
    public IIpcStrategy.Type getType() {
        return IIpcStrategy.Type.ACCOUNT_MANAGER_ADD_ACCOUNT;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp$Companion;", "", "()V", "AUTHAPP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE", "", "CONTENT_PROVIDER_PATH_KEY", "CP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE", "LTW_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE", "REQUEST_BUNDLE_KEY", "TAG", "getTAG", "()Ljava/lang/String;", "getAccountTypeForEachPackage", "", "getAccountTypeForEachPackage$common_distRelease", "tryCreateInstance", "Lcom/microsoft/identity/common/internal/broker/ipc/AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp;", "context", "Landroid/content/Context;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final Map<String, String> getAccountTypeForEachPackage$common_distRelease() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)BrokerData.Companion.getDebugMockLtw().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.LTW_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE), TuplesKt.to((Object)BrokerData.Companion.getProdLTW().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.LTW_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE), TuplesKt.to((Object)BrokerData.Companion.getDebugMockCp().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.CP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE), TuplesKt.to((Object)BrokerData.Companion.getProdCompanyPortal().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.CP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE), TuplesKt.to((Object)BrokerData.Companion.getDebugMockAuthApp().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.AUTHAPP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE), TuplesKt.to((Object)BrokerData.Companion.getProdMicrosoftAuthenticator().getPackageName(), (Object)AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.AUTHAPP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE)};
            Map result = MapsKt.mapOf((Pair[])pairArray);
            Iterable $this$forEach$iv = BrokerData.Companion.getProdBrokers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BrokerData it = (BrokerData)element$iv;
                boolean bl = false;
                boolean bl2 = result.containsKey(it.getPackageName());
                if (!_Assertions.ENABLED || bl2) continue;
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return result;
        }

        @Nullable
        public final AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp tryCreateInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object[] objectArray = new String[]{AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.LTW_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE, AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.CP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE, AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp.AUTHAPP_BACKUP_IPC_ACCOUNT_MANAGER_ACCOUNT_TYPE};
            if (!AccountManagerUtil.canUseAccountManagerOperation(context, SetsKt.setOf((Object[])objectArray))) {
                return null;
            }
            AccountManager accountManager = AccountManager.get((Context)context);
            return new AccountManagerBackupIpcStrategyTargetingSpecificBrokerApp(this.getAccountTypeForEachPackage$common_distRelease(), (Function2<? super String, ? super Bundle, Bundle>)((Function2)new Function2<String, Bundle, Bundle>(accountManager){
                final /* synthetic */ AccountManager $accountManager;
                {
                    this.$accountManager = $accountManager;
                    super(2);
                }

                @NotNull
                public final Bundle invoke(@NotNull String accountType, @NotNull Bundle requestBundle) {
                    Intrinsics.checkNotNullParameter((Object)accountType, (String)"accountType");
                    Intrinsics.checkNotNullParameter((Object)requestBundle, (String)"requestBundle");
                    Object object = this.$accountManager.addAccount(accountType, null, null, requestBundle, null, null, ProcessUtil.getPreferredHandler()).getResult(5L, TimeUnit.SECONDS);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accountManager.addAccoun\u2026sult(5, TimeUnit.SECONDS)");
                    return (Bundle)object;
                }
            }), (Function0<AuthenticatorDescription[]>)((Function0)new Function0<AuthenticatorDescription[]>(accountManager){
                final /* synthetic */ AccountManager $accountManager;
                {
                    this.$accountManager = $accountManager;
                    super(0);
                }

                @NotNull
                public final AuthenticatorDescription[] invoke() {
                    AuthenticatorDescription[] authenticatorDescriptionArray = this.$accountManager.getAuthenticatorTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)authenticatorDescriptionArray, (String)"accountManager.authenticatorTypes");
                    return authenticatorDescriptionArray;
                }
            }), new BrokerValidator(context));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

