/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BoundServiceClient;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;

public class MicrosoftAuthClient
extends BoundServiceClient<IMicrosoftAuthService> {
    private static final String MICROSOFT_AUTH_SERVICE_INTENT_FILTER = "com.microsoft.identity.client.MicrosoftAuth";
    private static final String MICROSOFT_AUTH_SERVICE_CLASS_NAME = "com.microsoft.identity.client.MicrosoftAuthService";

    public MicrosoftAuthClient(@NonNull Context context) {
        super(context, MICROSOFT_AUTH_SERVICE_CLASS_NAME, MICROSOFT_AUTH_SERVICE_INTENT_FILTER);
    }

    public MicrosoftAuthClient(@NonNull Context context, int timeOutInSeconds) {
        super(context, MICROSOFT_AUTH_SERVICE_INTENT_FILTER, MICROSOFT_AUTH_SERVICE_CLASS_NAME, timeOutInSeconds);
    }

    @Override
    @Nullable
    Bundle performOperationInternal(@NonNull BrokerOperationBundle brokerOperationBundle, @NonNull IMicrosoftAuthService microsoftAuthService) throws RemoteException, BrokerCommunicationException {
        Bundle inputBundle = brokerOperationBundle.getBundle();
        switch (brokerOperationBundle.getOperation()) {
            case MSAL_HELLO: {
                return microsoftAuthService.hello(inputBundle);
            }
            case MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST: {
                Intent intent = microsoftAuthService.getIntentForInteractiveRequest();
                Bundle bundle = intent.getExtras();
                if (intent.getComponent() != null && !TextUtils.isEmpty((CharSequence)intent.getPackage()) && !TextUtils.isEmpty((CharSequence)intent.getComponent().getClassName())) {
                    bundle.putString("broker.package.name", intent.getPackage());
                    bundle.putString("broker.activity.name", intent.getComponent().getClassName());
                }
                return bundle;
            }
            case MSAL_ACQUIRE_TOKEN_SILENT: {
                return microsoftAuthService.acquireTokenSilently(inputBundle);
            }
            case MSAL_GET_ACCOUNTS: {
                return microsoftAuthService.getAccounts(inputBundle);
            }
            case MSAL_REMOVE_ACCOUNT: {
                return microsoftAuthService.removeAccount(inputBundle);
            }
            case MSAL_GET_DEVICE_MODE: {
                return microsoftAuthService.getDeviceMode();
            }
            case MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE: {
                return microsoftAuthService.getCurrentAccount(inputBundle);
            }
            case MSAL_SIGN_OUT_FROM_SHARED_DEVICE: {
                return microsoftAuthService.removeAccountFromSharedDevice(inputBundle);
            }
            case MSAL_GENERATE_SHR: {
                return microsoftAuthService.generateSignedHttpRequest(inputBundle);
            }
        }
        String errorMessage = "Operation " + brokerOperationBundle.getOperation().name() + " is not supported by MicrosoftAuthClient.";
        throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_CLIENT_SIDE, IIpcStrategy.Type.BOUND_SERVICE, errorMessage, null);
    }

    @Override
    @NonNull
    IMicrosoftAuthService getInterfaceFromIBinder(@NonNull IBinder binder) {
        IMicrosoftAuthService service = IMicrosoftAuthService.Stub.asInterface(binder);
        if (service == null) {
            throw new IllegalStateException("Failed to extract IMicrosoftAuthService from IBinder.", null);
        }
        return service;
    }
}

