/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;

public final class ParcelableUtil {
    public static byte[] marshall(@NonNull Parcelable parcelable) {
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    public static Parcel unmarshall(@NonNull byte[] bytes) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        return parcel;
    }

    public static <T> T unmarshall(@NonNull byte[] bytes, @NonNull Parcelable.Creator<T> creator) {
        Parcel parcel = ParcelableUtil.unmarshall(bytes);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }

    private ParcelableUtil() {
    }
}

