/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;
import java.util.ArrayList;
import java.util.Arrays;

public class UserChoiceDialog
extends SmartcardDialog {
    private final PositiveButtonListener mPositiveButtonListener;
    private final CancelCbaCallback mCancelCbaCallback;

    public UserChoiceDialog(@NonNull PositiveButtonListener positiveButtonListener, @NonNull CancelCbaCallback cancelCbaCallback, @NonNull Activity activity) {
        super(activity);
        this.mPositiveButtonListener = positiveButtonListener;
        this.mCancelCbaCallback = cancelCbaCallback;
        this.createDialog();
    }

    @Override
    void createDialog() {
        ArrayList<String> choicesList = new ArrayList<String>();
        choicesList.add(this.mActivity.getResources().getString(R.string.user_choice_dialog_on_device_name));
        choicesList.add(this.mActivity.getResources().getString(R.string.user_choice_dialog_smartcard_name));
        CharSequence[] choicesArray = (String[])Arrays.copyOf(choicesList.toArray(), choicesList.size(), String[].class);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity, R.style.UserChoiceAlertDialogTheme).setTitle(R.string.user_choice_dialog_title).setSingleChoiceItems(choicesArray, 0, null).setPositiveButton(R.string.user_choice_dialog_positive_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                int checkedPosition = ((AlertDialog)dialogInterface).getListView().getCheckedItemPosition();
                UserChoiceDialog.this.mPositiveButtonListener.onClick(checkedPosition);
            }
        }).setNegativeButton(R.string.user_choice_dialog_negative_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                UserChoiceDialog.this.mCancelCbaCallback.onCancel();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                UserChoiceDialog.this.mCancelCbaCallback.onCancel();
            }
        });
        this.mDialog = dialog;
    }

    @Override
    void onCancelCba() {
        this.mCancelCbaCallback.onCancel();
    }

    public static interface CancelCbaCallback {
        public void onCancel();
    }

    public static interface PositiveButtonListener {
        public void onClick(int var1);
    }
}

