/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IUsbConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;

public class UsbSmartcardCertBasedAuthChallengeHandler
extends AbstractSmartcardCertBasedAuthChallengeHandler<AbstractUsbSmartcardCertBasedAuthManager> {
    public UsbSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull AbstractUsbSmartcardCertBasedAuthManager usbSmartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        super(activity, usbSmartcardCertBasedAuthManager, dialogHolder, telemetryHelper, UsbSmartcardCertBasedAuthChallengeHandler.class.getSimpleName());
        final String methodTag = this.TAG + ":UsbSmartcardCertBasedAuthChallengeHandler";
        ((AbstractUsbSmartcardCertBasedAuthManager)this.mCbaManager).setConnectionCallback(new IUsbConnectionCallback(){

            @Override
            public void onCreateConnection() {
                UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
            }

            @Override
            public void onClosedConnection() {
                if (UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.isDialogShowing()) {
                    UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.onCancelCba();
                    UsbSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_early_unplug_dialog_title, R.string.smartcard_early_unplug_dialog_message);
                    Logger.verbose(methodTag, "Smartcard was disconnected while dialog was still displayed.");
                }
            }
        });
    }

    @Override
    protected void onPausedSmartcardDiscovery() {
    }

    @Override
    protected SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request) {
        final String methodTag = this.TAG + ":getSmartcardPinDialogPositiveButtonListener";
        return new SmartcardPinDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(final @NonNull char[] pin) {
                ((AbstractUsbSmartcardCertBasedAuthManager)UsbSmartcardCertBasedAuthChallengeHandler.this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

                    @Override
                    public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                        UsbSmartcardCertBasedAuthChallengeHandler.this.tryUsingSmartcardWithPin(pin, certDetails, request, session);
                        UsbSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }

                    @Override
                    public void onException(@NonNull Exception e) {
                        UsbSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                        request.cancel();
                        UsbSmartcardCertBasedAuthChallengeHandler.this.clearPin(pin);
                    }
                });
            }
        };
    }

    @Override
    @RequiresApi(api=21)
    protected void setPinDialogForIncorrectAttempt(@NonNull ICertDetails certDetails, @NonNull ClientCertRequest request) {
        this.mDialogHolder.setPinDialogErrorMode();
    }
}

