/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardDialog;

public class SmartcardErrorDialog
extends SmartcardDialog {
    private final int mTitleStringResourceId;
    private final int mMessageStringResourceId;
    private final DismissCallback mDismissCallback;

    public SmartcardErrorDialog(int titleStringResourceId, int messageStringResourceId, @NonNull DismissCallback dismissCallback, @NonNull Activity activity) {
        super(activity);
        this.mTitleStringResourceId = titleStringResourceId;
        this.mMessageStringResourceId = messageStringResourceId;
        this.mDismissCallback = dismissCallback;
        this.createDialog();
    }

    @Override
    protected void createDialog() {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)SmartcardErrorDialog.this.mActivity, R.style.ErrorAlertDialogTheme).setTitle(SmartcardErrorDialog.this.mTitleStringResourceId).setMessage(SmartcardErrorDialog.this.mMessageStringResourceId).setPositiveButton(R.string.smartcard_error_dialog_positive_button, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SmartcardErrorDialog.this.mDismissCallback.onClick();
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.setCanceledOnTouchOutside(false);
                dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        SmartcardErrorDialog.this.mDismissCallback.onClick();
                    }
                });
                SmartcardErrorDialog.this.mDialog = dialog;
            }
        });
    }

    @Override
    void onCancelCba() {
        this.mDismissCallback.onClick();
    }

    public static interface DismissCallback {
        public void onClick();
    }
}

