/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKitNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.YubiKitUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.logging.Logger;
import com.yubico.yubikit.android.transport.nfc.NfcNotAvailable;

public class SmartcardCertBasedAuthManagerFactory {
    private static final String TAG = SmartcardCertBasedAuthManagerFactory.class.getSimpleName();

    @Nullable
    static AbstractUsbSmartcardCertBasedAuthManager createUsbSmartcardCertBasedAuthManager(@NonNull Context context) {
        String methodTag = TAG + ":createUsbSmartcardCertBasedAuthManager";
        if (context.getSystemService("usb") == null) {
            Logger.info(methodTag, "Certificate Based Authentication via YubiKey not enabled due to device not supporting the USB_SERVICE system service.");
            return null;
        }
        return new YubiKitUsbSmartcardCertBasedAuthManager(context);
    }

    @Nullable
    static AbstractNfcSmartcardCertBasedAuthManager createNfcSmartcardCertBasedAuthManager(@NonNull Context context) {
        String methodTag = TAG + ":createNfcSmartcardCertBasedAuthManager";
        try {
            return new YubiKitNfcSmartcardCertBasedAuthManager(context);
        }
        catch (NfcNotAvailable e) {
            Logger.info(methodTag, "Device does not support NFC capabilities.");
            return null;
        }
    }
}

