/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.providers.RawAuthorizationResult;
import com.microsoft.identity.common.logging.Logger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSmartcardCertBasedAuthChallengeHandler<T extends AbstractSmartcardCertBasedAuthManager<?>>
implements ICertBasedAuthChallengeHandler {
    protected static final String MAX_ATTEMPTS_MESSAGE = "User has reached the maximum failed attempts allowed.";
    protected static final String NO_PIV_CERTS_FOUND_MESSAGE = "No PIV certificates found on smartcard device.";
    protected static final String USER_CANCEL_MESSAGE = "User canceled smartcard CBA flow.";
    protected final String TAG;
    protected final Activity mActivity;
    protected final T mCbaManager;
    protected final IDialogHolder mDialogHolder;
    protected final ICertBasedAuthTelemetryHelper mTelemetryHelper;
    protected boolean mIsSmartcardCertBasedAuthProceeding;

    public AbstractSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull T smartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper, @NonNull String tag) {
        this.TAG = tag;
        this.mActivity = activity;
        this.mIsSmartcardCertBasedAuthProceeding = false;
        this.mCbaManager = smartcardCertBasedAuthManager;
        this.mDialogHolder = dialogHolder;
        this.mTelemetryHelper = telemetryHelper;
        this.mTelemetryHelper.setCertBasedAuthChallengeHandler(this.TAG);
    }

    @Override
    @RequiresApi(api=21)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = this.TAG + ":processChallenge";
        ((AbstractSmartcardCertBasedAuthManager)this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

            @Override
            public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                if (session.getPinAttemptsRemaining() == 0) {
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.promptTooManyFailedPinAttempts(methodTag);
                    request.cancel();
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.onPausedSmartcardDiscovery();
                    return;
                }
                List<ICertDetails> certList = session.getCertDetailsList();
                if (certList.isEmpty()) {
                    Logger.info(methodTag, AbstractSmartcardCertBasedAuthChallengeHandler.NO_PIV_CERTS_FOUND_MESSAGE);
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure(AbstractSmartcardCertBasedAuthChallengeHandler.NO_PIV_CERTS_FOUND_MESSAGE);
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_no_cert_dialog_title, R.string.smartcard_no_cert_dialog_message);
                    request.cancel();
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.onPausedSmartcardDiscovery();
                    return;
                }
                AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showCertPickerDialog(certList, AbstractSmartcardCertBasedAuthChallengeHandler.this.getSmartcardCertPickerDialogPositiveButtonListener(request), new SmartcardCertPickerDialog.CancelCbaCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onCancel() {
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure(AbstractSmartcardCertBasedAuthChallengeHandler.USER_CANCEL_MESSAGE);
                        request.cancel();
                    }
                });
                AbstractSmartcardCertBasedAuthChallengeHandler.this.onPausedSmartcardDiscovery();
            }

            @Override
            public void onException(@NonNull Exception e) {
                AbstractSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                request.cancel();
            }
        });
        return null;
    }

    protected abstract void onPausedSmartcardDiscovery();

    protected void promptTooManyFailedPinAttempts(@NonNull String methodTag) {
        Logger.info(methodTag, MAX_ATTEMPTS_MESSAGE);
        this.mTelemetryHelper.setResultFailure(MAX_ATTEMPTS_MESSAGE);
        this.mDialogHolder.showErrorDialog(R.string.smartcard_max_attempt_dialog_title, R.string.smartcard_max_attempt_dialog_message);
    }

    protected void indicateGeneralException(@NonNull String methodTag, @NonNull Exception e) {
        Logger.error(methodTag, e.getMessage(), e);
        this.mTelemetryHelper.setResultFailure(e);
        this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
    }

    private SmartcardCertPickerDialog.PositiveButtonListener getSmartcardCertPickerDialogPositiveButtonListener(final @NonNull ClientCertRequest request) {
        return new SmartcardCertPickerDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(@NonNull ICertDetails certDetails) {
                AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showPinDialog(AbstractSmartcardCertBasedAuthChallengeHandler.this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), new SmartcardPinDialog.CancelCbaCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onCancel() {
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure(AbstractSmartcardCertBasedAuthChallengeHandler.USER_CANCEL_MESSAGE);
                        request.cancel();
                    }
                });
            }
        };
    }

    protected abstract SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(@NonNull ICertDetails var1, @NonNull ClientCertRequest var2);

    @RequiresApi(api=21)
    protected void tryUsingSmartcardWithPin(@NonNull char[] pin, @NonNull ICertDetails certDetails, @NonNull ClientCertRequest request, @NonNull ISmartcardSession session) throws Exception {
        String methodTag = this.TAG + ":tryUsingSmartcardWithPin";
        if (session.verifyPin(pin)) {
            this.useSmartcardCertForAuth(certDetails, pin, session, request);
            return;
        }
        int attemptsRemaining = session.getPinAttemptsRemaining();
        this.onPausedSmartcardDiscovery();
        if (attemptsRemaining == 0) {
            this.promptTooManyFailedPinAttempts(methodTag);
            request.cancel();
            return;
        }
        this.setPinDialogForIncorrectAttempt(certDetails, request);
    }

    protected abstract void setPinDialogForIncorrectAttempt(@NonNull ICertDetails var1, @NonNull ClientCertRequest var2);

    @RequiresApi(api=21)
    protected void useSmartcardCertForAuth(@NonNull ICertDetails certDetails, @NonNull char[] pin, @NonNull ISmartcardSession session, @NonNull ClientCertRequest request) throws Exception {
        ((AbstractSmartcardCertBasedAuthManager)this.mCbaManager).initBeforeProceedingWithRequest(this.mTelemetryHelper);
        PrivateKey privateKey = session.getKeyForAuth(certDetails, pin);
        X509Certificate[] chain = new X509Certificate[]{certDetails.getCertificate()};
        this.mDialogHolder.dismissDialog();
        this.mIsSmartcardCertBasedAuthProceeding = true;
        request.proceed(privateKey, chain);
    }

    protected void clearPin(@NonNull char[] pin) {
        Arrays.fill(pin, '\u0000');
    }

    @Override
    public void emitTelemetryForCertBasedAuthResults(@NonNull RawAuthorizationResult response) {
        if (!this.mIsSmartcardCertBasedAuthProceeding) {
            return;
        }
        RawAuthorizationResult.ResultCode resultCode = response.getResultCode();
        if (resultCode == RawAuthorizationResult.ResultCode.NON_OAUTH_ERROR || resultCode == RawAuthorizationResult.ResultCode.SDK_CANCELLED || resultCode == RawAuthorizationResult.ResultCode.CANCELLED) {
            BaseException exception = response.getException();
            if (exception != null) {
                this.mTelemetryHelper.setResultFailure((Exception)((Object)exception));
                return;
            }
            this.mTelemetryHelper.setResultFailure(resultCode.toString());
            return;
        }
        this.mTelemetryHelper.setResultSuccess();
    }

    @Override
    public void cleanUp() {
        this.mDialogHolder.dismissDialog();
        ((AbstractSmartcardCertBasedAuthManager)this.mCbaManager).clearConnectionCallback();
    }
}

