/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.microsoft.identity.common.adal.internal.net.DefaultConnectionService;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.IntuneMAMEnrollmentIdGateway;
import com.microsoft.identity.common.internal.ui.webview.WebViewUtil;
import com.microsoft.identity.common.java.commands.ICommand;
import com.microsoft.identity.common.java.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.java.util.IPlatformUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import lombok.NonNull;

public class AndroidPlatformUtil
implements IPlatformUtil {
    private static final String TAG = AndroidPlatformUtil.class.getSimpleName();
    @NonNull
    private final Context mContext;
    @Nullable
    private final Activity mActivity;

    public List<BrowserDescriptor> getBrowserSafeListForBroker() {
        ArrayList<BrowserDescriptor> browserDescriptors = new ArrayList<BrowserDescriptor>();
        HashSet<String> signatureHashes = new HashSet<String>();
        signatureHashes.add("7fmduHKTdHHrlMvldlEqAIlSfii1tl35bxj1OXN5Ve8c4lU6URVu4xtSHc3BVZxS6WWJnxMDhIfQN0N0K2NDJg==");
        BrowserDescriptor chrome = new BrowserDescriptor("com.android.chrome", signatureHashes, null, null);
        browserDescriptors.add(chrome);
        return browserDescriptors;
    }

    @Nullable
    public String getInstalledCompanyPortalVersion() {
        try {
            PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo("com.microsoft.windowsintune.companyportal", 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public void throwIfNetworkNotAvailable(boolean performPowerOptimizationCheck) throws ClientException {
        DefaultConnectionService connectionService = new DefaultConnectionService(this.mContext);
        if (performPowerOptimizationCheck && connectionService.isNetworkDisabledFromOptimizations()) {
            throw new ClientException("device_network_not_available_doze_mode", "Connection is not available to refresh token because power optimization is enabled. And the device is in doze mode or the app is standby");
        }
        if (!connectionService.isConnectionAvailable()) {
            throw new ClientException("device_network_not_available", "Connection is not available to refresh token");
        }
    }

    public void removeCookiesFromWebView() {
        WebViewUtil.removeCookiesFromWebView(this.mContext);
    }

    public boolean isValidCallingApp(@NonNull String redirectUri, @NonNull String packageName) {
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked non-null but is null");
        }
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        return BrokerValidator.isValidBrokerRedirect(redirectUri, this.mContext, packageName);
    }

    @Nullable
    public String getEnrollmentId(@NonNull String userId, @NonNull String packageName) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (packageName == null) {
            throw new NullPointerException("packageName is marked non-null but is null");
        }
        return IntuneMAMEnrollmentIdGateway.getInstance().getEnrollmentId(this.mContext, userId, packageName);
    }

    public void onReturnCommandResult(@NonNull ICommand<?> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.optionallyReorderTasks(command);
    }

    public long getNanosecondTime() {
        if (Build.VERSION.SDK_INT >= 17) {
            return SystemClock.elapsedRealtimeNanos();
        }
        return System.nanoTime();
    }

    public void postCommandResult(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(runnable);
    }

    public KeyManagerFactory getSslContextKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance("X509");
    }

    @Nullable
    public String getPackageNameFromUid(int uid) {
        return this.mContext.getPackageManager().getNameForUid(uid);
    }

    private void optionallyReorderTasks(@NonNull ICommand<?> command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        String methodTag = TAG + ":optionallyReorderTasks";
        if (command instanceof InteractiveTokenCommand) {
            if (this.mActivity == null) {
                throw new IllegalStateException("Activity cannot be null in an interactive session.");
            }
            InteractiveTokenCommand interactiveTokenCommand = (InteractiveTokenCommand)command;
            InteractiveTokenCommandParameters interactiveTokenCommandParameters = (InteractiveTokenCommandParameters)interactiveTokenCommand.getParameters();
            if (interactiveTokenCommandParameters.getHandleNullTaskAffinity() && !AndroidPlatformUtil.hasTaskAffinity(this.mActivity)) {
                ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
                if (activityManager != null) {
                    activityManager.moveTaskToFront(this.mActivity.getTaskId(), 0);
                } else {
                    Logger.warn((String)methodTag, (String)"ActivityManager was null; Unable to bring task for the foreground.");
                }
            }
        }
    }

    private static boolean hasTaskAffinity(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        String methodTag = TAG + ":hasTaskAffinity";
        PackageManager packageManager = activity.getPackageManager();
        try {
            ActivityInfo startActivityInfo;
            ComponentName componentName = activity.getComponentName();
            ActivityInfo activityInfo = startActivityInfo = componentName != null ? packageManager.getActivityInfo(componentName, 0) : null;
            if (startActivityInfo == null) {
                return false;
            }
            return startActivityInfo.taskAffinity != null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.warn((String)methodTag, (String)"Unable to get ActivityInfo for activity provided to start authorization.");
            return true;
        }
    }

    public AndroidPlatformUtil(@NonNull Context mContext, @Nullable Activity mActivity) {
        if (mContext == null) {
            throw new NullPointerException("mContext is marked non-null but is null");
        }
        this.mContext = mContext;
        this.mActivity = mActivity;
    }
}

