/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageHelper {
    private static final String TAG = "CallerInfo";
    private PackageManager mPackageManager;

    public PackageHelper(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    public String getCurrentSignatureForPackage(String packageName) {
        String methodTag = "CallerInfo:getCurrentSignatureForPackage";
        try {
            return PackageHelper.getCurrentSignatureForPackage(PackageHelper.getPackageInfo(this.mPackageManager, packageName));
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:getCurrentSignatureForPackage", "Calling App's package does not exist in PackageManager. ", "", e);
            return null;
        }
    }

    public static String getCurrentSignatureForPackage(PackageInfo packageInfo) {
        String methodTag = "CallerInfo:getCurrentSignatureForPackage";
        try {
            Signature[] signatures = PackageHelper.getSignatures(packageInfo);
            if (signatures != null && signatures.length > 0) {
                Signature signature = signatures[0];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error("CallerInfo:getCurrentSignatureForPackage", "Digest SHA algorithm does not exists. ", "", e);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        String methodTag = "CallerInfo:getUIDForPackage";
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:getUIDForPackage", "Package is not found. ", "Package name: " + packageName, e);
        }
        return callingUID;
    }

    public boolean isPackageInstalledAndEnabled(Context context, String packageName) {
        String methodTag = "CallerInfo:isPackageInstalledAndEnabled";
        boolean enabled = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 0);
            if (applicationInfo != null) {
                enabled = applicationInfo.enabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo:isPackageInstalledAndEnabled", "Package is not found. Package name: " + packageName, e);
        }
        Logger.info("CallerInfo:isPackageInstalledAndEnabled", " Is package installed and enabled? [" + enabled + "]");
        return enabled;
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        String methodTag = "CallerInfo:getBrokerRedirectUrl";
        if (!StringExtensions.isNullOrBlank(packageName) && !StringExtensions.isNullOrBlank(signatureDigest)) {
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF-8"), URLEncoder.encode(signatureDigest, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error("CallerInfo:getBrokerRedirectUrl", "", "Encoding is not supported", e);
            }
        }
        return "";
    }

    public static Signature[] getSignatures(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            if (packageInfo.signingInfo == null) {
                return null;
            }
            if (packageInfo.signingInfo.hasMultipleSigners()) {
                return packageInfo.signingInfo.getApkContentsSigners();
            }
            return packageInfo.signingInfo.getSigningCertificateHistory();
        }
        return packageInfo.signatures;
    }

    public static int getPackageManagerSignaturesFlag() {
        if (Build.VERSION.SDK_INT >= 28) {
            return 0x8000000;
        }
        return 64;
    }

    public static PackageInfo getPackageInfo(@NonNull PackageManager packageManager, @NonNull String packageName) throws PackageManager.NameNotFoundException {
        return packageManager.getPackageInfo(packageName, PackageHelper.getPackageManagerSignaturesFlag());
    }

    public static Signature[] getSignatures(@NonNull Context context) throws PackageManager.NameNotFoundException {
        return PackageHelper.getSignatures(PackageHelper.getPackageInfo(context.getPackageManager(), context.getPackageName()));
    }
}

