/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.callrecords;

import com.microsoft.graph.models.callrecords.FeedbackTokenSet;
import com.microsoft.graph.models.callrecords.UserFeedbackRating;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserFeedback
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserFeedback() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserFeedback createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserFeedback();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(4);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("rating", n -> this.setRating((UserFeedbackRating)n.getEnumValue(UserFeedbackRating::forValue)));
        deserializerMap.put("text", n -> this.setText(n.getStringValue()));
        deserializerMap.put("tokens", n -> this.setTokens((FeedbackTokenSet)n.getObjectValue(FeedbackTokenSet::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public UserFeedbackRating getRating() {
        return (UserFeedbackRating)((Object)this.backingStore.get("rating"));
    }

    @Nullable
    public String getText() {
        return (String)this.backingStore.get("text");
    }

    @Nullable
    public FeedbackTokenSet getTokens() {
        return (FeedbackTokenSet)this.backingStore.get("tokens");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("rating", (Enum)this.getRating());
        writer.writeStringValue("text", this.getText());
        writer.writeObjectValue("tokens", (Parsable)this.getTokens(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRating(@Nullable UserFeedbackRating value) {
        this.backingStore.set("rating", (Object)value);
    }

    public void setText(@Nullable String value) {
        this.backingStore.set("text", (Object)value);
    }

    public void setTokens(@Nullable FeedbackTokenSet value) {
        this.backingStore.set("tokens", (Object)value);
    }
}

