/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serviceclient;

import com.azure.core.credential.TokenCredential;
import com.microsoft.graph.BaseGraphServiceClient;
import com.microsoft.graph.core.authentication.AzureIdentityAuthenticationProvider;
import com.microsoft.graph.core.requests.BaseGraphRequestAdapter;
import com.microsoft.graph.core.requests.BatchRequestBuilder;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.requests.options.GraphClientOption;
import com.microsoft.graph.serviceclient.CustomBatchRequestBuilder;
import com.microsoft.graph.users.UsersRequestBuilder;
import com.microsoft.graph.users.item.UserItemRequestBuilder;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.authentication.AnonymousAuthenticationProvider;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.store.BackingStoreFactory;
import com.microsoft.kiota.store.InMemoryBackingStoreFactory;
import jakarta.annotation.Nonnull;
import okhttp3.OkHttpClient;

public class GraphServiceClient
extends BaseGraphServiceClient
implements IBaseClient {
    private RequestAdapter graphServiceClientRequestAdapter;

    @Nonnull
    public static GraphClientOption getGraphClientOptions() {
        GraphClientOption graphClientOptions = new GraphClientOption();
        graphClientOptions.setGraphServiceTargetVersion("v1.0");
        graphClientOptions.setClientLibraryVersion("6.53.0");
        return graphClientOptions;
    }

    public GraphServiceClient(@Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, (BackingStoreFactory)new InMemoryBackingStoreFactory());
        this.graphServiceClientRequestAdapter = requestAdapter;
    }

    public GraphServiceClient(@Nonnull AuthenticationProvider authenticationProvider) {
        this((RequestAdapter)new BaseGraphRequestAdapter(authenticationProvider, null, "v1.0", GraphServiceClient.getGraphClientOptions()));
    }

    public GraphServiceClient(@Nonnull AuthenticationProvider authenticationProvider, @Nonnull OkHttpClient client, @Nonnull BaseGraphRequestAdapter.Clouds clouds) {
        this((RequestAdapter)new BaseGraphRequestAdapter(authenticationProvider, clouds, "v1.0", client));
    }

    public GraphServiceClient(@Nonnull AuthenticationProvider authenticationProvider, @Nonnull OkHttpClient client) {
        this((RequestAdapter)new BaseGraphRequestAdapter(authenticationProvider, null, "v1.0", client));
    }

    public GraphServiceClient(@Nonnull OkHttpClient client) {
        this((AuthenticationProvider)new AnonymousAuthenticationProvider(), client);
    }

    public GraphServiceClient(@Nonnull TokenCredential tokenCredential, String ... scopes) {
        this((AuthenticationProvider)new AzureIdentityAuthenticationProvider(tokenCredential, new String[0], scopes));
    }

    public void setRequestAdapter(@Nonnull RequestAdapter requestAdapter) {
        this.graphServiceClientRequestAdapter = requestAdapter;
    }

    @Nonnull
    public RequestAdapter getRequestAdapter() {
        return this.graphServiceClientRequestAdapter;
    }

    @Nonnull
    public BatchRequestBuilder getBatchRequestBuilder() {
        return new CustomBatchRequestBuilder(this.graphServiceClientRequestAdapter);
    }

    @Nonnull
    public UserItemRequestBuilder me() {
        return new UsersRequestBuilder(this.pathParameters, this.graphServiceClientRequestAdapter).byUserId("TokenToReplace");
    }
}

