/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.ResourceAccessEvent;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class UserAccount
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public UserAccount() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static UserAccount createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserAccount();
    }

    @Nullable
    public String getAccountName() {
        return (String)this.backingStore.get("accountName");
    }

    @Nullable
    public UUID getActiveDirectoryObjectGuid() {
        return (UUID)this.backingStore.get("activeDirectoryObjectGuid");
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAzureAdUserId() {
        return (String)this.backingStore.get("azureAdUserId");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getDomainName() {
        return (String)this.backingStore.get("domainName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("accountName", n -> this.setAccountName(n.getStringValue()));
        deserializerMap.put("activeDirectoryObjectGuid", n -> this.setActiveDirectoryObjectGuid(n.getUUIDValue()));
        deserializerMap.put("azureAdUserId", n -> this.setAzureAdUserId(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("domainName", n -> this.setDomainName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("resourceAccessEvents", n -> this.setResourceAccessEvents(n.getCollectionOfObjectValues(ResourceAccessEvent::createFromDiscriminatorValue)));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        deserializerMap.put("userSid", n -> this.setUserSid(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<ResourceAccessEvent> getResourceAccessEvents() {
        return (List)this.backingStore.get("resourceAccessEvents");
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    @Nullable
    public String getUserSid() {
        return (String)this.backingStore.get("userSid");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("accountName", this.getAccountName());
        writer.writeUUIDValue("activeDirectoryObjectGuid", this.getActiveDirectoryObjectGuid());
        writer.writeStringValue("azureAdUserId", this.getAzureAdUserId());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("domainName", this.getDomainName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("resourceAccessEvents", this.getResourceAccessEvents());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
        writer.writeStringValue("userSid", this.getUserSid());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAccountName(@Nullable String value) {
        this.backingStore.set("accountName", (Object)value);
    }

    public void setActiveDirectoryObjectGuid(@Nullable UUID value) {
        this.backingStore.set("activeDirectoryObjectGuid", (Object)value);
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAzureAdUserId(@Nullable String value) {
        this.backingStore.set("azureAdUserId", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setDomainName(@Nullable String value) {
        this.backingStore.set("domainName", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setResourceAccessEvents(@Nullable List<ResourceAccessEvent> value) {
        this.backingStore.set("resourceAccessEvents", value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }

    public void setUserSid(@Nullable String value) {
        this.backingStore.set("userSid", (Object)value);
    }
}

