/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChallengingWord;
import com.microsoft.graph.models.Entity;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ReadingAssignmentSubmission
extends Entity
implements Parsable {
    @Nonnull
    public static ReadingAssignmentSubmission createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ReadingAssignmentSubmission();
    }

    @Nullable
    public Double getAccuracyScore() {
        return (Double)this.backingStore.get("accuracyScore");
    }

    @Nullable
    public String getAction() {
        return (String)this.backingStore.get("action");
    }

    @Nullable
    public String getAssignmentId() {
        return (String)this.backingStore.get("assignmentId");
    }

    @Nullable
    public List<ChallengingWord> getChallengingWords() {
        return (List)this.backingStore.get("challengingWords");
    }

    @Nullable
    public String getClassId() {
        return (String)this.backingStore.get("classId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("accuracyScore", n -> this.setAccuracyScore(n.getDoubleValue()));
        deserializerMap.put("action", n -> this.setAction(n.getStringValue()));
        deserializerMap.put("assignmentId", n -> this.setAssignmentId(n.getStringValue()));
        deserializerMap.put("challengingWords", n -> this.setChallengingWords(n.getCollectionOfObjectValues(ChallengingWord::createFromDiscriminatorValue)));
        deserializerMap.put("classId", n -> this.setClassId(n.getStringValue()));
        deserializerMap.put("insertions", n -> this.setInsertions(n.getLongValue()));
        deserializerMap.put("mispronunciations", n -> this.setMispronunciations(n.getLongValue()));
        deserializerMap.put("missedExclamationMarks", n -> this.setMissedExclamationMarks(n.getLongValue()));
        deserializerMap.put("missedPeriods", n -> this.setMissedPeriods(n.getLongValue()));
        deserializerMap.put("missedQuestionMarks", n -> this.setMissedQuestionMarks(n.getLongValue()));
        deserializerMap.put("missedShorts", n -> this.setMissedShorts(n.getLongValue()));
        deserializerMap.put("monotoneScore", n -> this.setMonotoneScore(n.getDoubleValue()));
        deserializerMap.put("omissions", n -> this.setOmissions(n.getLongValue()));
        deserializerMap.put("repetitions", n -> this.setRepetitions(n.getLongValue()));
        deserializerMap.put("selfCorrections", n -> this.setSelfCorrections(n.getLongValue()));
        deserializerMap.put("studentId", n -> this.setStudentId(n.getStringValue()));
        deserializerMap.put("submissionDateTime", n -> this.setSubmissionDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("submissionId", n -> this.setSubmissionId(n.getStringValue()));
        deserializerMap.put("unexpectedPauses", n -> this.setUnexpectedPauses(n.getLongValue()));
        deserializerMap.put("wordCount", n -> this.setWordCount(n.getLongValue()));
        deserializerMap.put("wordsPerMinute", n -> this.setWordsPerMinute(n.getDoubleValue()));
        return deserializerMap;
    }

    @Nullable
    public Long getInsertions() {
        return (Long)this.backingStore.get("insertions");
    }

    @Nullable
    public Long getMispronunciations() {
        return (Long)this.backingStore.get("mispronunciations");
    }

    @Nullable
    public Long getMissedExclamationMarks() {
        return (Long)this.backingStore.get("missedExclamationMarks");
    }

    @Nullable
    public Long getMissedPeriods() {
        return (Long)this.backingStore.get("missedPeriods");
    }

    @Nullable
    public Long getMissedQuestionMarks() {
        return (Long)this.backingStore.get("missedQuestionMarks");
    }

    @Nullable
    public Long getMissedShorts() {
        return (Long)this.backingStore.get("missedShorts");
    }

    @Nullable
    public Double getMonotoneScore() {
        return (Double)this.backingStore.get("monotoneScore");
    }

    @Nullable
    public Long getOmissions() {
        return (Long)this.backingStore.get("omissions");
    }

    @Nullable
    public Long getRepetitions() {
        return (Long)this.backingStore.get("repetitions");
    }

    @Nullable
    public Long getSelfCorrections() {
        return (Long)this.backingStore.get("selfCorrections");
    }

    @Nullable
    public String getStudentId() {
        return (String)this.backingStore.get("studentId");
    }

    @Nullable
    public OffsetDateTime getSubmissionDateTime() {
        return (OffsetDateTime)this.backingStore.get("submissionDateTime");
    }

    @Nullable
    public String getSubmissionId() {
        return (String)this.backingStore.get("submissionId");
    }

    @Nullable
    public Long getUnexpectedPauses() {
        return (Long)this.backingStore.get("unexpectedPauses");
    }

    @Nullable
    public Long getWordCount() {
        return (Long)this.backingStore.get("wordCount");
    }

    @Nullable
    public Double getWordsPerMinute() {
        return (Double)this.backingStore.get("wordsPerMinute");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeDoubleValue("accuracyScore", this.getAccuracyScore());
        writer.writeStringValue("action", this.getAction());
        writer.writeStringValue("assignmentId", this.getAssignmentId());
        writer.writeCollectionOfObjectValues("challengingWords", this.getChallengingWords());
        writer.writeStringValue("classId", this.getClassId());
        writer.writeLongValue("insertions", this.getInsertions());
        writer.writeLongValue("mispronunciations", this.getMispronunciations());
        writer.writeLongValue("missedExclamationMarks", this.getMissedExclamationMarks());
        writer.writeLongValue("missedPeriods", this.getMissedPeriods());
        writer.writeLongValue("missedQuestionMarks", this.getMissedQuestionMarks());
        writer.writeLongValue("missedShorts", this.getMissedShorts());
        writer.writeDoubleValue("monotoneScore", this.getMonotoneScore());
        writer.writeLongValue("omissions", this.getOmissions());
        writer.writeLongValue("repetitions", this.getRepetitions());
        writer.writeLongValue("selfCorrections", this.getSelfCorrections());
        writer.writeStringValue("studentId", this.getStudentId());
        writer.writeOffsetDateTimeValue("submissionDateTime", this.getSubmissionDateTime());
        writer.writeStringValue("submissionId", this.getSubmissionId());
        writer.writeLongValue("unexpectedPauses", this.getUnexpectedPauses());
        writer.writeLongValue("wordCount", this.getWordCount());
        writer.writeDoubleValue("wordsPerMinute", this.getWordsPerMinute());
    }

    public void setAccuracyScore(@Nullable Double value) {
        this.backingStore.set("accuracyScore", (Object)value);
    }

    public void setAction(@Nullable String value) {
        this.backingStore.set("action", (Object)value);
    }

    public void setAssignmentId(@Nullable String value) {
        this.backingStore.set("assignmentId", (Object)value);
    }

    public void setChallengingWords(@Nullable List<ChallengingWord> value) {
        this.backingStore.set("challengingWords", value);
    }

    public void setClassId(@Nullable String value) {
        this.backingStore.set("classId", (Object)value);
    }

    public void setInsertions(@Nullable Long value) {
        this.backingStore.set("insertions", (Object)value);
    }

    public void setMispronunciations(@Nullable Long value) {
        this.backingStore.set("mispronunciations", (Object)value);
    }

    public void setMissedExclamationMarks(@Nullable Long value) {
        this.backingStore.set("missedExclamationMarks", (Object)value);
    }

    public void setMissedPeriods(@Nullable Long value) {
        this.backingStore.set("missedPeriods", (Object)value);
    }

    public void setMissedQuestionMarks(@Nullable Long value) {
        this.backingStore.set("missedQuestionMarks", (Object)value);
    }

    public void setMissedShorts(@Nullable Long value) {
        this.backingStore.set("missedShorts", (Object)value);
    }

    public void setMonotoneScore(@Nullable Double value) {
        this.backingStore.set("monotoneScore", (Object)value);
    }

    public void setOmissions(@Nullable Long value) {
        this.backingStore.set("omissions", (Object)value);
    }

    public void setRepetitions(@Nullable Long value) {
        this.backingStore.set("repetitions", (Object)value);
    }

    public void setSelfCorrections(@Nullable Long value) {
        this.backingStore.set("selfCorrections", (Object)value);
    }

    public void setStudentId(@Nullable String value) {
        this.backingStore.set("studentId", (Object)value);
    }

    public void setSubmissionDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("submissionDateTime", (Object)value);
    }

    public void setSubmissionId(@Nullable String value) {
        this.backingStore.set("submissionId", (Object)value);
    }

    public void setUnexpectedPauses(@Nullable Long value) {
        this.backingStore.set("unexpectedPauses", (Object)value);
    }

    public void setWordCount(@Nullable Long value) {
        this.backingStore.set("wordCount", (Object)value);
    }

    public void setWordsPerMinute(@Nullable Double value) {
        this.backingStore.set("wordsPerMinute", (Object)value);
    }
}

