/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ContentBase;
import com.microsoft.graph.models.ProcessConversationMetadata;
import com.microsoft.graph.models.ProcessFileMetadata;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessContentMetadataBase
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ProcessContentMetadataBase() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ProcessContentMetadataBase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.processConversationMetadata": {
                    return new ProcessConversationMetadata();
                }
                case "#microsoft.graph.processFileMetadata": {
                    return new ProcessFileMetadata();
                }
            }
        }
        return new ProcessContentMetadataBase();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ContentBase getContent() {
        return (ContentBase)this.backingStore.get("content");
    }

    @Nullable
    public String getCorrelationId() {
        return (String)this.backingStore.get("correlationId");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("content", n -> this.setContent((ContentBase)n.getObjectValue(ContentBase::createFromDiscriminatorValue)));
        deserializerMap.put("correlationId", n -> this.setCorrelationId(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("identifier", n -> this.setIdentifier(n.getStringValue()));
        deserializerMap.put("isTruncated", n -> this.setIsTruncated(n.getBooleanValue()));
        deserializerMap.put("length", n -> this.setLength(n.getLongValue()));
        deserializerMap.put("modifiedDateTime", n -> this.setModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("sequenceNumber", n -> this.setSequenceNumber(n.getLongValue()));
        return deserializerMap;
    }

    @Nullable
    public String getIdentifier() {
        return (String)this.backingStore.get("identifier");
    }

    @Nullable
    public Boolean getIsTruncated() {
        return (Boolean)this.backingStore.get("isTruncated");
    }

    @Nullable
    public Long getLength() {
        return (Long)this.backingStore.get("length");
    }

    @Nullable
    public OffsetDateTime getModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("modifiedDateTime");
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Long getSequenceNumber() {
        return (Long)this.backingStore.get("sequenceNumber");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("content", (Parsable)this.getContent(), new Parsable[0]);
        writer.writeStringValue("correlationId", this.getCorrelationId());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("identifier", this.getIdentifier());
        writer.writeBooleanValue("isTruncated", this.getIsTruncated());
        writer.writeLongValue("length", this.getLength());
        writer.writeOffsetDateTimeValue("modifiedDateTime", this.getModifiedDateTime());
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeLongValue("sequenceNumber", this.getSequenceNumber());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setContent(@Nullable ContentBase value) {
        this.backingStore.set("content", (Object)value);
    }

    public void setCorrelationId(@Nullable String value) {
        this.backingStore.set("correlationId", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setIdentifier(@Nullable String value) {
        this.backingStore.set("identifier", (Object)value);
    }

    public void setIsTruncated(@Nullable Boolean value) {
        this.backingStore.set("isTruncated", (Object)value);
    }

    public void setLength(@Nullable Long value) {
        this.backingStore.set("length", (Object)value);
    }

    public void setModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("modifiedDateTime", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSequenceNumber(@Nullable Long value) {
        this.backingStore.set("sequenceNumber", (Object)value);
    }
}

