/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.EducationClass;
import com.microsoft.graph.models.EducationSchool;
import com.microsoft.graph.models.EducationUser;
import com.microsoft.graph.models.ReportsRoot;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EducationRoot
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public EducationRoot() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static EducationRoot createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EducationRoot();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public List<EducationClass> getClasses() {
        return (List)this.backingStore.get("classes");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("classes", n -> this.setClasses(n.getCollectionOfObjectValues(EducationClass::createFromDiscriminatorValue)));
        deserializerMap.put("me", n -> this.setMe((EducationUser)n.getObjectValue(EducationUser::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("reports", n -> this.setReports((ReportsRoot)n.getObjectValue(ReportsRoot::createFromDiscriminatorValue)));
        deserializerMap.put("schools", n -> this.setSchools(n.getCollectionOfObjectValues(EducationSchool::createFromDiscriminatorValue)));
        deserializerMap.put("users", n -> this.setUsers(n.getCollectionOfObjectValues(EducationUser::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public EducationUser getMe() {
        return (EducationUser)this.backingStore.get("me");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ReportsRoot getReports() {
        return (ReportsRoot)this.backingStore.get("reports");
    }

    @Nullable
    public List<EducationSchool> getSchools() {
        return (List)this.backingStore.get("schools");
    }

    @Nullable
    public List<EducationUser> getUsers() {
        return (List)this.backingStore.get("users");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("classes", this.getClasses());
        writer.writeObjectValue("me", (Parsable)this.getMe(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("reports", (Parsable)this.getReports(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("schools", this.getSchools());
        writer.writeCollectionOfObjectValues("users", this.getUsers());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setClasses(@Nullable List<EducationClass> value) {
        this.backingStore.set("classes", value);
    }

    public void setMe(@Nullable EducationUser value) {
        this.backingStore.set("me", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setReports(@Nullable ReportsRoot value) {
        this.backingStore.set("reports", (Object)value);
    }

    public void setSchools(@Nullable List<EducationSchool> value) {
        this.backingStore.set("schools", value);
    }

    public void setUsers(@Nullable List<EducationUser> value) {
        this.backingStore.set("users", value);
    }
}

