/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.UserExperienceAnalyticsHealthState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class UserExperienceAnalyticsAppHealthDevicePerformance
extends Entity
implements Parsable {
    @Nonnull
    public static UserExperienceAnalyticsAppHealthDevicePerformance createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new UserExperienceAnalyticsAppHealthDevicePerformance();
    }

    @Nullable
    public Integer getAppCrashCount() {
        return (Integer)this.backingStore.get("appCrashCount");
    }

    @Nullable
    public Integer getAppHangCount() {
        return (Integer)this.backingStore.get("appHangCount");
    }

    @Nullable
    public Integer getCrashedAppCount() {
        return (Integer)this.backingStore.get("crashedAppCount");
    }

    @Nullable
    public Double getDeviceAppHealthScore() {
        return (Double)this.backingStore.get("deviceAppHealthScore");
    }

    @Nullable
    public String getDeviceDisplayName() {
        return (String)this.backingStore.get("deviceDisplayName");
    }

    @Nullable
    public String getDeviceId() {
        return (String)this.backingStore.get("deviceId");
    }

    @Nullable
    public String getDeviceManufacturer() {
        return (String)this.backingStore.get("deviceManufacturer");
    }

    @Nullable
    public String getDeviceModel() {
        return (String)this.backingStore.get("deviceModel");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("appCrashCount", n -> this.setAppCrashCount(n.getIntegerValue()));
        deserializerMap.put("appHangCount", n -> this.setAppHangCount(n.getIntegerValue()));
        deserializerMap.put("crashedAppCount", n -> this.setCrashedAppCount(n.getIntegerValue()));
        deserializerMap.put("deviceAppHealthScore", n -> this.setDeviceAppHealthScore(n.getDoubleValue()));
        deserializerMap.put("deviceDisplayName", n -> this.setDeviceDisplayName(n.getStringValue()));
        deserializerMap.put("deviceId", n -> this.setDeviceId(n.getStringValue()));
        deserializerMap.put("deviceManufacturer", n -> this.setDeviceManufacturer(n.getStringValue()));
        deserializerMap.put("deviceModel", n -> this.setDeviceModel(n.getStringValue()));
        deserializerMap.put("healthStatus", n -> this.setHealthStatus((UserExperienceAnalyticsHealthState)n.getEnumValue(UserExperienceAnalyticsHealthState::forValue)));
        deserializerMap.put("meanTimeToFailureInMinutes", n -> this.setMeanTimeToFailureInMinutes(n.getIntegerValue()));
        deserializerMap.put("processedDateTime", n -> this.setProcessedDateTime(n.getOffsetDateTimeValue()));
        return deserializerMap;
    }

    @Nullable
    public UserExperienceAnalyticsHealthState getHealthStatus() {
        return (UserExperienceAnalyticsHealthState)((Object)this.backingStore.get("healthStatus"));
    }

    @Nullable
    public Integer getMeanTimeToFailureInMinutes() {
        return (Integer)this.backingStore.get("meanTimeToFailureInMinutes");
    }

    @Nullable
    public OffsetDateTime getProcessedDateTime() {
        return (OffsetDateTime)this.backingStore.get("processedDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("appCrashCount", this.getAppCrashCount());
        writer.writeIntegerValue("appHangCount", this.getAppHangCount());
        writer.writeIntegerValue("crashedAppCount", this.getCrashedAppCount());
        writer.writeDoubleValue("deviceAppHealthScore", this.getDeviceAppHealthScore());
        writer.writeStringValue("deviceDisplayName", this.getDeviceDisplayName());
        writer.writeStringValue("deviceId", this.getDeviceId());
        writer.writeStringValue("deviceManufacturer", this.getDeviceManufacturer());
        writer.writeStringValue("deviceModel", this.getDeviceModel());
        writer.writeEnumValue("healthStatus", (Enum)this.getHealthStatus());
        writer.writeIntegerValue("meanTimeToFailureInMinutes", this.getMeanTimeToFailureInMinutes());
        writer.writeOffsetDateTimeValue("processedDateTime", this.getProcessedDateTime());
    }

    public void setAppCrashCount(@Nullable Integer value) {
        this.backingStore.set("appCrashCount", (Object)value);
    }

    public void setAppHangCount(@Nullable Integer value) {
        this.backingStore.set("appHangCount", (Object)value);
    }

    public void setCrashedAppCount(@Nullable Integer value) {
        this.backingStore.set("crashedAppCount", (Object)value);
    }

    public void setDeviceAppHealthScore(@Nullable Double value) {
        this.backingStore.set("deviceAppHealthScore", (Object)value);
    }

    public void setDeviceDisplayName(@Nullable String value) {
        this.backingStore.set("deviceDisplayName", (Object)value);
    }

    public void setDeviceId(@Nullable String value) {
        this.backingStore.set("deviceId", (Object)value);
    }

    public void setDeviceManufacturer(@Nullable String value) {
        this.backingStore.set("deviceManufacturer", (Object)value);
    }

    public void setDeviceModel(@Nullable String value) {
        this.backingStore.set("deviceModel", (Object)value);
    }

    public void setHealthStatus(@Nullable UserExperienceAnalyticsHealthState value) {
        this.backingStore.set("healthStatus", (Object)value);
    }

    public void setMeanTimeToFailureInMinutes(@Nullable Integer value) {
        this.backingStore.set("meanTimeToFailureInMinutes", (Object)value);
    }

    public void setProcessedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("processedDateTime", (Object)value);
    }
}

