/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.WindowsSettingInstance;
import com.microsoft.graph.models.WindowsSettingType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsSetting
extends Entity
implements Parsable {
    @Nonnull
    public static WindowsSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsSetting();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("instances", n -> this.setInstances(n.getCollectionOfObjectValues(WindowsSettingInstance::createFromDiscriminatorValue)));
        deserializerMap.put("payloadType", n -> this.setPayloadType(n.getStringValue()));
        deserializerMap.put("settingType", n -> this.setSettingType((WindowsSettingType)n.getEnumValue(WindowsSettingType::forValue)));
        deserializerMap.put("windowsDeviceId", n -> this.setWindowsDeviceId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<WindowsSettingInstance> getInstances() {
        return (List)this.backingStore.get("instances");
    }

    @Nullable
    public String getPayloadType() {
        return (String)this.backingStore.get("payloadType");
    }

    @Nullable
    public WindowsSettingType getSettingType() {
        return (WindowsSettingType)((Object)this.backingStore.get("settingType"));
    }

    @Nullable
    public String getWindowsDeviceId() {
        return (String)this.backingStore.get("windowsDeviceId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("instances", this.getInstances());
        writer.writeStringValue("payloadType", this.getPayloadType());
        writer.writeEnumValue("settingType", (Enum)this.getSettingType());
        writer.writeStringValue("windowsDeviceId", this.getWindowsDeviceId());
    }

    public void setInstances(@Nullable List<WindowsSettingInstance> value) {
        this.backingStore.set("instances", value);
    }

    public void setPayloadType(@Nullable String value) {
        this.backingStore.set("payloadType", (Object)value);
    }

    public void setSettingType(@Nullable WindowsSettingType value) {
        this.backingStore.set("settingType", (Object)value);
    }

    public void setWindowsDeviceId(@Nullable String value) {
        this.backingStore.set("windowsDeviceId", (Object)value);
    }
}

