/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.graph.models.AuthenticationMethodKeyStrength;
import com.microsoft.graph.models.AuthenticationMethodPlatform;
import com.microsoft.graph.models.Device;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PlatformCredentialAuthenticationMethod
extends AuthenticationMethod
implements Parsable {
    public PlatformCredentialAuthenticationMethod() {
        this.setOdataType("#microsoft.graph.platformCredentialAuthenticationMethod");
    }

    @Nonnull
    public static PlatformCredentialAuthenticationMethod createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PlatformCredentialAuthenticationMethod();
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public Device getDevice() {
        return (Device)this.backingStore.get("device");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("device", n -> this.setDevice((Device)n.getObjectValue(Device::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("keyStrength", n -> this.setKeyStrength((AuthenticationMethodKeyStrength)n.getEnumValue(AuthenticationMethodKeyStrength::forValue)));
        deserializerMap.put("platform", n -> this.setPlatform((AuthenticationMethodPlatform)n.getEnumValue(AuthenticationMethodPlatform::forValue)));
        return deserializerMap;
    }

    @Nullable
    public AuthenticationMethodKeyStrength getKeyStrength() {
        return (AuthenticationMethodKeyStrength)((Object)this.backingStore.get("keyStrength"));
    }

    @Nullable
    public AuthenticationMethodPlatform getPlatform() {
        return (AuthenticationMethodPlatform)((Object)this.backingStore.get("platform"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeObjectValue("device", (Parsable)this.getDevice(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeEnumValue("keyStrength", (Enum)this.getKeyStrength());
        writer.writeEnumValue("platform", (Enum)this.getPlatform());
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDevice(@Nullable Device value) {
        this.backingStore.set("device", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setKeyStrength(@Nullable AuthenticationMethodKeyStrength value) {
        this.backingStore.set("keyStrength", (Object)value);
    }

    public void setPlatform(@Nullable AuthenticationMethodPlatform value) {
        this.backingStore.set("platform", (Object)value);
    }
}

