/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidManagedAppProtection;
import com.microsoft.graph.models.DefaultManagedAppProtection;
import com.microsoft.graph.models.IosManagedAppProtection;
import com.microsoft.graph.models.ManagedAppClipboardSharingLevel;
import com.microsoft.graph.models.ManagedAppDataStorageLocation;
import com.microsoft.graph.models.ManagedAppDataTransferLevel;
import com.microsoft.graph.models.ManagedAppPinCharacterSet;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.models.ManagedBrowserType;
import com.microsoft.graph.models.TargetedManagedAppProtection;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManagedAppProtection
extends ManagedAppPolicy
implements Parsable {
    public ManagedAppProtection() {
        this.setOdataType("#microsoft.graph.managedAppProtection");
    }

    @Nonnull
    public static ManagedAppProtection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidManagedAppProtection": {
                    return new AndroidManagedAppProtection();
                }
                case "#microsoft.graph.defaultManagedAppProtection": {
                    return new DefaultManagedAppProtection();
                }
                case "#microsoft.graph.iosManagedAppProtection": {
                    return new IosManagedAppProtection();
                }
                case "#microsoft.graph.targetedManagedAppProtection": {
                    return new TargetedManagedAppProtection();
                }
            }
        }
        return new ManagedAppProtection();
    }

    @Nullable
    public List<ManagedAppDataStorageLocation> getAllowedDataStorageLocations() {
        return (List)this.backingStore.get("allowedDataStorageLocations");
    }

    @Nullable
    public ManagedAppDataTransferLevel getAllowedInboundDataTransferSources() {
        return (ManagedAppDataTransferLevel)((Object)this.backingStore.get("allowedInboundDataTransferSources"));
    }

    @Nullable
    public ManagedAppClipboardSharingLevel getAllowedOutboundClipboardSharingLevel() {
        return (ManagedAppClipboardSharingLevel)((Object)this.backingStore.get("allowedOutboundClipboardSharingLevel"));
    }

    @Nullable
    public ManagedAppDataTransferLevel getAllowedOutboundDataTransferDestinations() {
        return (ManagedAppDataTransferLevel)((Object)this.backingStore.get("allowedOutboundDataTransferDestinations"));
    }

    @Nullable
    public Boolean getContactSyncBlocked() {
        return (Boolean)this.backingStore.get("contactSyncBlocked");
    }

    @Nullable
    public Boolean getDataBackupBlocked() {
        return (Boolean)this.backingStore.get("dataBackupBlocked");
    }

    @Nullable
    public Boolean getDeviceComplianceRequired() {
        return (Boolean)this.backingStore.get("deviceComplianceRequired");
    }

    @Nullable
    public Boolean getDisableAppPinIfDevicePinIsSet() {
        return (Boolean)this.backingStore.get("disableAppPinIfDevicePinIsSet");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("allowedDataStorageLocations", n -> this.setAllowedDataStorageLocations(n.getCollectionOfEnumValues(ManagedAppDataStorageLocation::forValue)));
        deserializerMap.put("allowedInboundDataTransferSources", n -> this.setAllowedInboundDataTransferSources((ManagedAppDataTransferLevel)n.getEnumValue(ManagedAppDataTransferLevel::forValue)));
        deserializerMap.put("allowedOutboundClipboardSharingLevel", n -> this.setAllowedOutboundClipboardSharingLevel((ManagedAppClipboardSharingLevel)n.getEnumValue(ManagedAppClipboardSharingLevel::forValue)));
        deserializerMap.put("allowedOutboundDataTransferDestinations", n -> this.setAllowedOutboundDataTransferDestinations((ManagedAppDataTransferLevel)n.getEnumValue(ManagedAppDataTransferLevel::forValue)));
        deserializerMap.put("contactSyncBlocked", n -> this.setContactSyncBlocked(n.getBooleanValue()));
        deserializerMap.put("dataBackupBlocked", n -> this.setDataBackupBlocked(n.getBooleanValue()));
        deserializerMap.put("deviceComplianceRequired", n -> this.setDeviceComplianceRequired(n.getBooleanValue()));
        deserializerMap.put("disableAppPinIfDevicePinIsSet", n -> this.setDisableAppPinIfDevicePinIsSet(n.getBooleanValue()));
        deserializerMap.put("fingerprintBlocked", n -> this.setFingerprintBlocked(n.getBooleanValue()));
        deserializerMap.put("managedBrowser", n -> this.setManagedBrowser(n.getEnumSetValue(ManagedBrowserType::forValue)));
        deserializerMap.put("managedBrowserToOpenLinksRequired", n -> this.setManagedBrowserToOpenLinksRequired(n.getBooleanValue()));
        deserializerMap.put("maximumPinRetries", n -> this.setMaximumPinRetries(n.getIntegerValue()));
        deserializerMap.put("minimumPinLength", n -> this.setMinimumPinLength(n.getIntegerValue()));
        deserializerMap.put("minimumRequiredAppVersion", n -> this.setMinimumRequiredAppVersion(n.getStringValue()));
        deserializerMap.put("minimumRequiredOsVersion", n -> this.setMinimumRequiredOsVersion(n.getStringValue()));
        deserializerMap.put("minimumWarningAppVersion", n -> this.setMinimumWarningAppVersion(n.getStringValue()));
        deserializerMap.put("minimumWarningOsVersion", n -> this.setMinimumWarningOsVersion(n.getStringValue()));
        deserializerMap.put("organizationalCredentialsRequired", n -> this.setOrganizationalCredentialsRequired(n.getBooleanValue()));
        deserializerMap.put("periodBeforePinReset", n -> this.setPeriodBeforePinReset(n.getPeriodAndDurationValue()));
        deserializerMap.put("periodOfflineBeforeAccessCheck", n -> this.setPeriodOfflineBeforeAccessCheck(n.getPeriodAndDurationValue()));
        deserializerMap.put("periodOfflineBeforeWipeIsEnforced", n -> this.setPeriodOfflineBeforeWipeIsEnforced(n.getPeriodAndDurationValue()));
        deserializerMap.put("periodOnlineBeforeAccessCheck", n -> this.setPeriodOnlineBeforeAccessCheck(n.getPeriodAndDurationValue()));
        deserializerMap.put("pinCharacterSet", n -> this.setPinCharacterSet((ManagedAppPinCharacterSet)n.getEnumValue(ManagedAppPinCharacterSet::forValue)));
        deserializerMap.put("pinRequired", n -> this.setPinRequired(n.getBooleanValue()));
        deserializerMap.put("printBlocked", n -> this.setPrintBlocked(n.getBooleanValue()));
        deserializerMap.put("saveAsBlocked", n -> this.setSaveAsBlocked(n.getBooleanValue()));
        deserializerMap.put("simplePinBlocked", n -> this.setSimplePinBlocked(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getFingerprintBlocked() {
        return (Boolean)this.backingStore.get("fingerprintBlocked");
    }

    @Nullable
    public EnumSet<ManagedBrowserType> getManagedBrowser() {
        return (EnumSet)this.backingStore.get("managedBrowser");
    }

    @Nullable
    public Boolean getManagedBrowserToOpenLinksRequired() {
        return (Boolean)this.backingStore.get("managedBrowserToOpenLinksRequired");
    }

    @Nullable
    public Integer getMaximumPinRetries() {
        return (Integer)this.backingStore.get("maximumPinRetries");
    }

    @Nullable
    public Integer getMinimumPinLength() {
        return (Integer)this.backingStore.get("minimumPinLength");
    }

    @Nullable
    public String getMinimumRequiredAppVersion() {
        return (String)this.backingStore.get("minimumRequiredAppVersion");
    }

    @Nullable
    public String getMinimumRequiredOsVersion() {
        return (String)this.backingStore.get("minimumRequiredOsVersion");
    }

    @Nullable
    public String getMinimumWarningAppVersion() {
        return (String)this.backingStore.get("minimumWarningAppVersion");
    }

    @Nullable
    public String getMinimumWarningOsVersion() {
        return (String)this.backingStore.get("minimumWarningOsVersion");
    }

    @Nullable
    public Boolean getOrganizationalCredentialsRequired() {
        return (Boolean)this.backingStore.get("organizationalCredentialsRequired");
    }

    @Nullable
    public PeriodAndDuration getPeriodBeforePinReset() {
        return (PeriodAndDuration)this.backingStore.get("periodBeforePinReset");
    }

    @Nullable
    public PeriodAndDuration getPeriodOfflineBeforeAccessCheck() {
        return (PeriodAndDuration)this.backingStore.get("periodOfflineBeforeAccessCheck");
    }

    @Nullable
    public PeriodAndDuration getPeriodOfflineBeforeWipeIsEnforced() {
        return (PeriodAndDuration)this.backingStore.get("periodOfflineBeforeWipeIsEnforced");
    }

    @Nullable
    public PeriodAndDuration getPeriodOnlineBeforeAccessCheck() {
        return (PeriodAndDuration)this.backingStore.get("periodOnlineBeforeAccessCheck");
    }

    @Nullable
    public ManagedAppPinCharacterSet getPinCharacterSet() {
        return (ManagedAppPinCharacterSet)((Object)this.backingStore.get("pinCharacterSet"));
    }

    @Nullable
    public Boolean getPinRequired() {
        return (Boolean)this.backingStore.get("pinRequired");
    }

    @Nullable
    public Boolean getPrintBlocked() {
        return (Boolean)this.backingStore.get("printBlocked");
    }

    @Nullable
    public Boolean getSaveAsBlocked() {
        return (Boolean)this.backingStore.get("saveAsBlocked");
    }

    @Nullable
    public Boolean getSimplePinBlocked() {
        return (Boolean)this.backingStore.get("simplePinBlocked");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfEnumValues("allowedDataStorageLocations", this.getAllowedDataStorageLocations());
        writer.writeEnumValue("allowedInboundDataTransferSources", (Enum)this.getAllowedInboundDataTransferSources());
        writer.writeEnumValue("allowedOutboundClipboardSharingLevel", (Enum)this.getAllowedOutboundClipboardSharingLevel());
        writer.writeEnumValue("allowedOutboundDataTransferDestinations", (Enum)this.getAllowedOutboundDataTransferDestinations());
        writer.writeBooleanValue("contactSyncBlocked", this.getContactSyncBlocked());
        writer.writeBooleanValue("dataBackupBlocked", this.getDataBackupBlocked());
        writer.writeBooleanValue("deviceComplianceRequired", this.getDeviceComplianceRequired());
        writer.writeBooleanValue("disableAppPinIfDevicePinIsSet", this.getDisableAppPinIfDevicePinIsSet());
        writer.writeBooleanValue("fingerprintBlocked", this.getFingerprintBlocked());
        writer.writeEnumSetValue("managedBrowser", this.getManagedBrowser());
        writer.writeBooleanValue("managedBrowserToOpenLinksRequired", this.getManagedBrowserToOpenLinksRequired());
        writer.writeIntegerValue("maximumPinRetries", this.getMaximumPinRetries());
        writer.writeIntegerValue("minimumPinLength", this.getMinimumPinLength());
        writer.writeStringValue("minimumRequiredAppVersion", this.getMinimumRequiredAppVersion());
        writer.writeStringValue("minimumRequiredOsVersion", this.getMinimumRequiredOsVersion());
        writer.writeStringValue("minimumWarningAppVersion", this.getMinimumWarningAppVersion());
        writer.writeStringValue("minimumWarningOsVersion", this.getMinimumWarningOsVersion());
        writer.writeBooleanValue("organizationalCredentialsRequired", this.getOrganizationalCredentialsRequired());
        writer.writePeriodAndDurationValue("periodBeforePinReset", this.getPeriodBeforePinReset());
        writer.writePeriodAndDurationValue("periodOfflineBeforeAccessCheck", this.getPeriodOfflineBeforeAccessCheck());
        writer.writePeriodAndDurationValue("periodOfflineBeforeWipeIsEnforced", this.getPeriodOfflineBeforeWipeIsEnforced());
        writer.writePeriodAndDurationValue("periodOnlineBeforeAccessCheck", this.getPeriodOnlineBeforeAccessCheck());
        writer.writeEnumValue("pinCharacterSet", (Enum)this.getPinCharacterSet());
        writer.writeBooleanValue("pinRequired", this.getPinRequired());
        writer.writeBooleanValue("printBlocked", this.getPrintBlocked());
        writer.writeBooleanValue("saveAsBlocked", this.getSaveAsBlocked());
        writer.writeBooleanValue("simplePinBlocked", this.getSimplePinBlocked());
    }

    public void setAllowedDataStorageLocations(@Nullable List<ManagedAppDataStorageLocation> value) {
        this.backingStore.set("allowedDataStorageLocations", value);
    }

    public void setAllowedInboundDataTransferSources(@Nullable ManagedAppDataTransferLevel value) {
        this.backingStore.set("allowedInboundDataTransferSources", (Object)value);
    }

    public void setAllowedOutboundClipboardSharingLevel(@Nullable ManagedAppClipboardSharingLevel value) {
        this.backingStore.set("allowedOutboundClipboardSharingLevel", (Object)value);
    }

    public void setAllowedOutboundDataTransferDestinations(@Nullable ManagedAppDataTransferLevel value) {
        this.backingStore.set("allowedOutboundDataTransferDestinations", (Object)value);
    }

    public void setContactSyncBlocked(@Nullable Boolean value) {
        this.backingStore.set("contactSyncBlocked", (Object)value);
    }

    public void setDataBackupBlocked(@Nullable Boolean value) {
        this.backingStore.set("dataBackupBlocked", (Object)value);
    }

    public void setDeviceComplianceRequired(@Nullable Boolean value) {
        this.backingStore.set("deviceComplianceRequired", (Object)value);
    }

    public void setDisableAppPinIfDevicePinIsSet(@Nullable Boolean value) {
        this.backingStore.set("disableAppPinIfDevicePinIsSet", (Object)value);
    }

    public void setFingerprintBlocked(@Nullable Boolean value) {
        this.backingStore.set("fingerprintBlocked", (Object)value);
    }

    public void setManagedBrowser(@Nullable EnumSet<ManagedBrowserType> value) {
        this.backingStore.set("managedBrowser", value);
    }

    public void setManagedBrowserToOpenLinksRequired(@Nullable Boolean value) {
        this.backingStore.set("managedBrowserToOpenLinksRequired", (Object)value);
    }

    public void setMaximumPinRetries(@Nullable Integer value) {
        this.backingStore.set("maximumPinRetries", (Object)value);
    }

    public void setMinimumPinLength(@Nullable Integer value) {
        this.backingStore.set("minimumPinLength", (Object)value);
    }

    public void setMinimumRequiredAppVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredAppVersion", (Object)value);
    }

    public void setMinimumRequiredOsVersion(@Nullable String value) {
        this.backingStore.set("minimumRequiredOsVersion", (Object)value);
    }

    public void setMinimumWarningAppVersion(@Nullable String value) {
        this.backingStore.set("minimumWarningAppVersion", (Object)value);
    }

    public void setMinimumWarningOsVersion(@Nullable String value) {
        this.backingStore.set("minimumWarningOsVersion", (Object)value);
    }

    public void setOrganizationalCredentialsRequired(@Nullable Boolean value) {
        this.backingStore.set("organizationalCredentialsRequired", (Object)value);
    }

    public void setPeriodBeforePinReset(@Nullable PeriodAndDuration value) {
        this.backingStore.set("periodBeforePinReset", (Object)value);
    }

    public void setPeriodOfflineBeforeAccessCheck(@Nullable PeriodAndDuration value) {
        this.backingStore.set("periodOfflineBeforeAccessCheck", (Object)value);
    }

    public void setPeriodOfflineBeforeWipeIsEnforced(@Nullable PeriodAndDuration value) {
        this.backingStore.set("periodOfflineBeforeWipeIsEnforced", (Object)value);
    }

    public void setPeriodOnlineBeforeAccessCheck(@Nullable PeriodAndDuration value) {
        this.backingStore.set("periodOnlineBeforeAccessCheck", (Object)value);
    }

    public void setPinCharacterSet(@Nullable ManagedAppPinCharacterSet value) {
        this.backingStore.set("pinCharacterSet", (Object)value);
    }

    public void setPinRequired(@Nullable Boolean value) {
        this.backingStore.set("pinRequired", (Object)value);
    }

    public void setPrintBlocked(@Nullable Boolean value) {
        this.backingStore.set("printBlocked", (Object)value);
    }

    public void setSaveAsBlocked(@Nullable Boolean value) {
        this.backingStore.set("saveAsBlocked", (Object)value);
    }

    public void setSimplePinBlocked(@Nullable Boolean value) {
        this.backingStore.set("simplePinBlocked", (Object)value);
    }
}

