/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DetectedAppPlatformType;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ManagedDevice;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DetectedApp
extends Entity
implements Parsable {
    @Nonnull
    public static DetectedApp createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DetectedApp();
    }

    @Nullable
    public Integer getDeviceCount() {
        return (Integer)this.backingStore.get("deviceCount");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("deviceCount", n -> this.setDeviceCount(n.getIntegerValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("managedDevices", n -> this.setManagedDevices(n.getCollectionOfObjectValues(ManagedDevice::createFromDiscriminatorValue)));
        deserializerMap.put("platform", n -> this.setPlatform((DetectedAppPlatformType)n.getEnumValue(DetectedAppPlatformType::forValue)));
        deserializerMap.put("publisher", n -> this.setPublisher(n.getStringValue()));
        deserializerMap.put("sizeInByte", n -> this.setSizeInByte(n.getLongValue()));
        deserializerMap.put("version", n -> this.setVersion(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<ManagedDevice> getManagedDevices() {
        return (List)this.backingStore.get("managedDevices");
    }

    @Nullable
    public DetectedAppPlatformType getPlatform() {
        return (DetectedAppPlatformType)((Object)this.backingStore.get("platform"));
    }

    @Nullable
    public String getPublisher() {
        return (String)this.backingStore.get("publisher");
    }

    @Nullable
    public Long getSizeInByte() {
        return (Long)this.backingStore.get("sizeInByte");
    }

    @Nullable
    public String getVersion() {
        return (String)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("deviceCount", this.getDeviceCount());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeCollectionOfObjectValues("managedDevices", this.getManagedDevices());
        writer.writeEnumValue("platform", (Enum)this.getPlatform());
        writer.writeStringValue("publisher", this.getPublisher());
        writer.writeLongValue("sizeInByte", this.getSizeInByte());
        writer.writeStringValue("version", this.getVersion());
    }

    public void setDeviceCount(@Nullable Integer value) {
        this.backingStore.set("deviceCount", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setManagedDevices(@Nullable List<ManagedDevice> value) {
        this.backingStore.set("managedDevices", value);
    }

    public void setPlatform(@Nullable DetectedAppPlatformType value) {
        this.backingStore.set("platform", (Object)value);
    }

    public void setPublisher(@Nullable String value) {
        this.backingStore.set("publisher", (Object)value);
    }

    public void setSizeInByte(@Nullable Long value) {
        this.backingStore.set("sizeInByte", (Object)value);
    }

    public void setVersion(@Nullable String value) {
        this.backingStore.set("version", (Object)value);
    }
}

