/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.users.item.messages.item;

import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.users.item.messages.item.attachments.AttachmentsRequestBuilder;
import com.microsoft.graph.users.item.messages.item.copy.CopyRequestBuilder;
import com.microsoft.graph.users.item.messages.item.createforward.CreateForwardRequestBuilder;
import com.microsoft.graph.users.item.messages.item.createreply.CreateReplyRequestBuilder;
import com.microsoft.graph.users.item.messages.item.createreplyall.CreateReplyAllRequestBuilder;
import com.microsoft.graph.users.item.messages.item.extensions.ExtensionsRequestBuilder;
import com.microsoft.graph.users.item.messages.item.forward.ForwardRequestBuilder;
import com.microsoft.graph.users.item.messages.item.move.MoveRequestBuilder;
import com.microsoft.graph.users.item.messages.item.reply.ReplyRequestBuilder;
import com.microsoft.graph.users.item.messages.item.replyall.ReplyAllRequestBuilder;
import com.microsoft.graph.users.item.messages.item.send.SendRequestBuilder;
import com.microsoft.graph.users.item.messages.item.value.ContentRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MessageItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public AttachmentsRequestBuilder attachments() {
        return new AttachmentsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ContentRequestBuilder content() {
        return new ContentRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CopyRequestBuilder copy() {
        return new CopyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateForwardRequestBuilder createForward() {
        return new CreateForwardRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateReplyRequestBuilder createReply() {
        return new CreateReplyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public CreateReplyAllRequestBuilder createReplyAll() {
        return new CreateReplyAllRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ExtensionsRequestBuilder extensions() {
        return new ExtensionsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ForwardRequestBuilder forward() {
        return new ForwardRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public MoveRequestBuilder move() {
        return new MoveRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ReplyRequestBuilder reply() {
        return new ReplyRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ReplyAllRequestBuilder replyAll() {
        return new ReplyAllRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public SendRequestBuilder send() {
        return new SendRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public MessageItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/messages/{message%2Did}{?%24expand,%24select,includeHiddenMessages*}", pathParameters);
    }

    public MessageItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/users/{user%2Did}/messages/{message%2Did}{?%24expand,%24select,includeHiddenMessages*}", rawUrl);
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nullable
    public Message get() {
        return this.get(null);
    }

    @Nullable
    public Message get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Message)this.requestAdapter.send(requestInfo, errorMapping, Message::createFromDiscriminatorValue);
    }

    @Nullable
    public Message patch(@Nonnull Message body) {
        return this.patch(body, null);
    }

    @Nullable
    public Message patch(@Nonnull Message body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("XXX", ODataError::createFromDiscriminatorValue);
        return (Message)this.requestAdapter.send(requestInfo, errorMapping, Message::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.DELETE, "{+baseurl}/users/{user%2Did}/messages/{message%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new DeleteRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Message body) {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull Message body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PATCH, "{+baseurl}/users/{user%2Did}/messages/{message%2Did}", (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PatchRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public MessageItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new MessageItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PatchRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public String[] expand;
        @Nullable
        public String includeHiddenMessages;
        @Nullable
        public String[] select;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("includeHiddenMessages", this.includeHiddenMessages);
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }

    public class DeleteRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

