/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.TeleconferenceDeviceMediaQuality;
import com.microsoft.graph.models.TeleconferenceDeviceScreenSharingQuality;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeleconferenceDeviceVideoQuality
extends TeleconferenceDeviceMediaQuality
implements Parsable {
    public TeleconferenceDeviceVideoQuality() {
        this.setOdataType("#microsoft.graph.teleconferenceDeviceVideoQuality");
    }

    @Nonnull
    public static TeleconferenceDeviceVideoQuality createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.teleconferenceDeviceScreenSharingQuality": {
                    return new TeleconferenceDeviceScreenSharingQuality();
                }
            }
        }
        return new TeleconferenceDeviceVideoQuality();
    }

    @Nullable
    public Double getAverageInboundBitRate() {
        return (Double)this.backingStore.get("averageInboundBitRate");
    }

    @Nullable
    public Double getAverageInboundFrameRate() {
        return (Double)this.backingStore.get("averageInboundFrameRate");
    }

    @Nullable
    public Double getAverageOutboundBitRate() {
        return (Double)this.backingStore.get("averageOutboundBitRate");
    }

    @Nullable
    public Double getAverageOutboundFrameRate() {
        return (Double)this.backingStore.get("averageOutboundFrameRate");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("averageInboundBitRate", n -> this.setAverageInboundBitRate(n.getDoubleValue()));
        deserializerMap.put("averageInboundFrameRate", n -> this.setAverageInboundFrameRate(n.getDoubleValue()));
        deserializerMap.put("averageOutboundBitRate", n -> this.setAverageOutboundBitRate(n.getDoubleValue()));
        deserializerMap.put("averageOutboundFrameRate", n -> this.setAverageOutboundFrameRate(n.getDoubleValue()));
        return deserializerMap;
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeDoubleValue("averageInboundBitRate", this.getAverageInboundBitRate());
        writer.writeDoubleValue("averageInboundFrameRate", this.getAverageInboundFrameRate());
        writer.writeDoubleValue("averageOutboundBitRate", this.getAverageOutboundBitRate());
        writer.writeDoubleValue("averageOutboundFrameRate", this.getAverageOutboundFrameRate());
    }

    public void setAverageInboundBitRate(@Nullable Double value) {
        this.backingStore.set("averageInboundBitRate", (Object)value);
    }

    public void setAverageInboundFrameRate(@Nullable Double value) {
        this.backingStore.set("averageInboundFrameRate", (Object)value);
    }

    public void setAverageOutboundBitRate(@Nullable Double value) {
        this.backingStore.set("averageOutboundBitRate", (Object)value);
    }

    public void setAverageOutboundFrameRate(@Nullable Double value) {
        this.backingStore.set("averageOutboundFrameRate", (Object)value);
    }
}

