/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.EmailSender;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AnalyzedMessageEvidence
extends AlertEvidence
implements Parsable {
    public AnalyzedMessageEvidence() {
        this.setOdataType("#microsoft.graph.security.analyzedMessageEvidence");
    }

    @Nonnull
    public static AnalyzedMessageEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new AnalyzedMessageEvidence();
    }

    @Nullable
    public String getAntiSpamDirection() {
        return (String)this.backingStore.get("antiSpamDirection");
    }

    @Nullable
    public Long getAttachmentsCount() {
        return (Long)this.backingStore.get("attachmentsCount");
    }

    @Nullable
    public String getDeliveryAction() {
        return (String)this.backingStore.get("deliveryAction");
    }

    @Nullable
    public String getDeliveryLocation() {
        return (String)this.backingStore.get("deliveryLocation");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("antiSpamDirection", n -> this.setAntiSpamDirection(n.getStringValue()));
        deserializerMap.put("attachmentsCount", n -> this.setAttachmentsCount(n.getLongValue()));
        deserializerMap.put("deliveryAction", n -> this.setDeliveryAction(n.getStringValue()));
        deserializerMap.put("deliveryLocation", n -> this.setDeliveryLocation(n.getStringValue()));
        deserializerMap.put("internetMessageId", n -> this.setInternetMessageId(n.getStringValue()));
        deserializerMap.put("language", n -> this.setLanguage(n.getStringValue()));
        deserializerMap.put("networkMessageId", n -> this.setNetworkMessageId(n.getStringValue()));
        deserializerMap.put("p1Sender", n -> this.setP1Sender((EmailSender)n.getObjectValue(EmailSender::createFromDiscriminatorValue)));
        deserializerMap.put("p2Sender", n -> this.setP2Sender((EmailSender)n.getObjectValue(EmailSender::createFromDiscriminatorValue)));
        deserializerMap.put("receivedDateTime", n -> this.setReceivedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("recipientEmailAddress", n -> this.setRecipientEmailAddress(n.getStringValue()));
        deserializerMap.put("senderIp", n -> this.setSenderIp(n.getStringValue()));
        deserializerMap.put("subject", n -> this.setSubject(n.getStringValue()));
        deserializerMap.put("threatDetectionMethods", n -> this.setThreatDetectionMethods(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("threats", n -> this.setThreats(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("urlCount", n -> this.setUrlCount(n.getLongValue()));
        deserializerMap.put("urls", n -> this.setUrls(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("urn", n -> this.setUrn(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getInternetMessageId() {
        return (String)this.backingStore.get("internetMessageId");
    }

    @Nullable
    public String getLanguage() {
        return (String)this.backingStore.get("language");
    }

    @Nullable
    public String getNetworkMessageId() {
        return (String)this.backingStore.get("networkMessageId");
    }

    @Nullable
    public EmailSender getP1Sender() {
        return (EmailSender)this.backingStore.get("p1Sender");
    }

    @Nullable
    public EmailSender getP2Sender() {
        return (EmailSender)this.backingStore.get("p2Sender");
    }

    @Nullable
    public OffsetDateTime getReceivedDateTime() {
        return (OffsetDateTime)this.backingStore.get("receivedDateTime");
    }

    @Nullable
    public String getRecipientEmailAddress() {
        return (String)this.backingStore.get("recipientEmailAddress");
    }

    @Nullable
    public String getSenderIp() {
        return (String)this.backingStore.get("senderIp");
    }

    @Nullable
    public String getSubject() {
        return (String)this.backingStore.get("subject");
    }

    @Nullable
    public List<String> getThreatDetectionMethods() {
        return (List)this.backingStore.get("threatDetectionMethods");
    }

    @Nullable
    public List<String> getThreats() {
        return (List)this.backingStore.get("threats");
    }

    @Nullable
    public Long getUrlCount() {
        return (Long)this.backingStore.get("urlCount");
    }

    @Nullable
    public List<String> getUrls() {
        return (List)this.backingStore.get("urls");
    }

    @Nullable
    public String getUrn() {
        return (String)this.backingStore.get("urn");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("antiSpamDirection", this.getAntiSpamDirection());
        writer.writeLongValue("attachmentsCount", this.getAttachmentsCount());
        writer.writeStringValue("deliveryAction", this.getDeliveryAction());
        writer.writeStringValue("deliveryLocation", this.getDeliveryLocation());
        writer.writeStringValue("internetMessageId", this.getInternetMessageId());
        writer.writeStringValue("language", this.getLanguage());
        writer.writeStringValue("networkMessageId", this.getNetworkMessageId());
        writer.writeObjectValue("p1Sender", (Parsable)this.getP1Sender(), new Parsable[0]);
        writer.writeObjectValue("p2Sender", (Parsable)this.getP2Sender(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("receivedDateTime", this.getReceivedDateTime());
        writer.writeStringValue("recipientEmailAddress", this.getRecipientEmailAddress());
        writer.writeStringValue("senderIp", this.getSenderIp());
        writer.writeStringValue("subject", this.getSubject());
        writer.writeCollectionOfPrimitiveValues("threatDetectionMethods", this.getThreatDetectionMethods());
        writer.writeCollectionOfPrimitiveValues("threats", this.getThreats());
        writer.writeLongValue("urlCount", this.getUrlCount());
        writer.writeCollectionOfPrimitiveValues("urls", this.getUrls());
        writer.writeStringValue("urn", this.getUrn());
    }

    public void setAntiSpamDirection(@Nullable String value) {
        this.backingStore.set("antiSpamDirection", (Object)value);
    }

    public void setAttachmentsCount(@Nullable Long value) {
        this.backingStore.set("attachmentsCount", (Object)value);
    }

    public void setDeliveryAction(@Nullable String value) {
        this.backingStore.set("deliveryAction", (Object)value);
    }

    public void setDeliveryLocation(@Nullable String value) {
        this.backingStore.set("deliveryLocation", (Object)value);
    }

    public void setInternetMessageId(@Nullable String value) {
        this.backingStore.set("internetMessageId", (Object)value);
    }

    public void setLanguage(@Nullable String value) {
        this.backingStore.set("language", (Object)value);
    }

    public void setNetworkMessageId(@Nullable String value) {
        this.backingStore.set("networkMessageId", (Object)value);
    }

    public void setP1Sender(@Nullable EmailSender value) {
        this.backingStore.set("p1Sender", (Object)value);
    }

    public void setP2Sender(@Nullable EmailSender value) {
        this.backingStore.set("p2Sender", (Object)value);
    }

    public void setReceivedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("receivedDateTime", (Object)value);
    }

    public void setRecipientEmailAddress(@Nullable String value) {
        this.backingStore.set("recipientEmailAddress", (Object)value);
    }

    public void setSenderIp(@Nullable String value) {
        this.backingStore.set("senderIp", (Object)value);
    }

    public void setSubject(@Nullable String value) {
        this.backingStore.set("subject", (Object)value);
    }

    public void setThreatDetectionMethods(@Nullable List<String> value) {
        this.backingStore.set("threatDetectionMethods", value);
    }

    public void setThreats(@Nullable List<String> value) {
        this.backingStore.set("threats", value);
    }

    public void setUrlCount(@Nullable Long value) {
        this.backingStore.set("urlCount", (Object)value);
    }

    public void setUrls(@Nullable List<String> value) {
        this.backingStore.set("urls", value);
    }

    public void setUrn(@Nullable String value) {
        this.backingStore.set("urn", (Object)value);
    }
}

