/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.StringKeyLongValuePair;
import com.microsoft.graph.models.SynchronizationProgress;
import com.microsoft.graph.models.SynchronizationQuarantine;
import com.microsoft.graph.models.SynchronizationStatusCode;
import com.microsoft.graph.models.SynchronizationTaskExecution;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SynchronizationStatus
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SynchronizationStatus() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SynchronizationStatus createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SynchronizationStatus();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public SynchronizationStatusCode getCode() {
        return (SynchronizationStatusCode)((Object)this.backingStore.get("code"));
    }

    @Nullable
    public Long getCountSuccessiveCompleteFailures() {
        return (Long)this.backingStore.get("countSuccessiveCompleteFailures");
    }

    @Nullable
    public Boolean getEscrowsPruned() {
        return (Boolean)this.backingStore.get("escrowsPruned");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("code", n -> this.setCode((SynchronizationStatusCode)n.getEnumValue(SynchronizationStatusCode::forValue)));
        deserializerMap.put("countSuccessiveCompleteFailures", n -> this.setCountSuccessiveCompleteFailures(n.getLongValue()));
        deserializerMap.put("escrowsPruned", n -> this.setEscrowsPruned(n.getBooleanValue()));
        deserializerMap.put("lastExecution", n -> this.setLastExecution((SynchronizationTaskExecution)n.getObjectValue(SynchronizationTaskExecution::createFromDiscriminatorValue)));
        deserializerMap.put("lastSuccessfulExecution", n -> this.setLastSuccessfulExecution((SynchronizationTaskExecution)n.getObjectValue(SynchronizationTaskExecution::createFromDiscriminatorValue)));
        deserializerMap.put("lastSuccessfulExecutionWithExports", n -> this.setLastSuccessfulExecutionWithExports((SynchronizationTaskExecution)n.getObjectValue(SynchronizationTaskExecution::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("progress", n -> this.setProgress(n.getCollectionOfObjectValues(SynchronizationProgress::createFromDiscriminatorValue)));
        deserializerMap.put("quarantine", n -> this.setQuarantine((SynchronizationQuarantine)n.getObjectValue(SynchronizationQuarantine::createFromDiscriminatorValue)));
        deserializerMap.put("steadyStateFirstAchievedTime", n -> this.setSteadyStateFirstAchievedTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("steadyStateLastAchievedTime", n -> this.setSteadyStateLastAchievedTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("synchronizedEntryCountByType", n -> this.setSynchronizedEntryCountByType(n.getCollectionOfObjectValues(StringKeyLongValuePair::createFromDiscriminatorValue)));
        deserializerMap.put("troubleshootingUrl", n -> this.setTroubleshootingUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public SynchronizationTaskExecution getLastExecution() {
        return (SynchronizationTaskExecution)this.backingStore.get("lastExecution");
    }

    @Nullable
    public SynchronizationTaskExecution getLastSuccessfulExecution() {
        return (SynchronizationTaskExecution)this.backingStore.get("lastSuccessfulExecution");
    }

    @Nullable
    public SynchronizationTaskExecution getLastSuccessfulExecutionWithExports() {
        return (SynchronizationTaskExecution)this.backingStore.get("lastSuccessfulExecutionWithExports");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<SynchronizationProgress> getProgress() {
        return (List)this.backingStore.get("progress");
    }

    @Nullable
    public SynchronizationQuarantine getQuarantine() {
        return (SynchronizationQuarantine)this.backingStore.get("quarantine");
    }

    @Nullable
    public OffsetDateTime getSteadyStateFirstAchievedTime() {
        return (OffsetDateTime)this.backingStore.get("steadyStateFirstAchievedTime");
    }

    @Nullable
    public OffsetDateTime getSteadyStateLastAchievedTime() {
        return (OffsetDateTime)this.backingStore.get("steadyStateLastAchievedTime");
    }

    @Nullable
    public List<StringKeyLongValuePair> getSynchronizedEntryCountByType() {
        return (List)this.backingStore.get("synchronizedEntryCountByType");
    }

    @Nullable
    public String getTroubleshootingUrl() {
        return (String)this.backingStore.get("troubleshootingUrl");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeEnumValue("code", (Enum)this.getCode());
        writer.writeLongValue("countSuccessiveCompleteFailures", this.getCountSuccessiveCompleteFailures());
        writer.writeBooleanValue("escrowsPruned", this.getEscrowsPruned());
        writer.writeObjectValue("lastExecution", (Parsable)this.getLastExecution(), new Parsable[0]);
        writer.writeObjectValue("lastSuccessfulExecution", (Parsable)this.getLastSuccessfulExecution(), new Parsable[0]);
        writer.writeObjectValue("lastSuccessfulExecutionWithExports", (Parsable)this.getLastSuccessfulExecutionWithExports(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("progress", this.getProgress());
        writer.writeObjectValue("quarantine", (Parsable)this.getQuarantine(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("steadyStateFirstAchievedTime", this.getSteadyStateFirstAchievedTime());
        writer.writeOffsetDateTimeValue("steadyStateLastAchievedTime", this.getSteadyStateLastAchievedTime());
        writer.writeCollectionOfObjectValues("synchronizedEntryCountByType", this.getSynchronizedEntryCountByType());
        writer.writeStringValue("troubleshootingUrl", this.getTroubleshootingUrl());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCode(@Nullable SynchronizationStatusCode value) {
        this.backingStore.set("code", (Object)value);
    }

    public void setCountSuccessiveCompleteFailures(@Nullable Long value) {
        this.backingStore.set("countSuccessiveCompleteFailures", (Object)value);
    }

    public void setEscrowsPruned(@Nullable Boolean value) {
        this.backingStore.set("escrowsPruned", (Object)value);
    }

    public void setLastExecution(@Nullable SynchronizationTaskExecution value) {
        this.backingStore.set("lastExecution", (Object)value);
    }

    public void setLastSuccessfulExecution(@Nullable SynchronizationTaskExecution value) {
        this.backingStore.set("lastSuccessfulExecution", (Object)value);
    }

    public void setLastSuccessfulExecutionWithExports(@Nullable SynchronizationTaskExecution value) {
        this.backingStore.set("lastSuccessfulExecutionWithExports", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProgress(@Nullable List<SynchronizationProgress> value) {
        this.backingStore.set("progress", value);
    }

    public void setQuarantine(@Nullable SynchronizationQuarantine value) {
        this.backingStore.set("quarantine", (Object)value);
    }

    public void setSteadyStateFirstAchievedTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("steadyStateFirstAchievedTime", (Object)value);
    }

    public void setSteadyStateLastAchievedTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("steadyStateLastAchievedTime", (Object)value);
    }

    public void setSynchronizedEntryCountByType(@Nullable List<StringKeyLongValuePair> value) {
        this.backingStore.set("synchronizedEntryCountByType", value);
    }

    public void setTroubleshootingUrl(@Nullable String value) {
        this.backingStore.set("troubleshootingUrl", (Object)value);
    }
}

