/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AmazonResourceEvidence;
import com.microsoft.graph.models.security.AnalyzedMessageEvidence;
import com.microsoft.graph.models.security.AzureResourceEvidence;
import com.microsoft.graph.models.security.BlobContainerEvidence;
import com.microsoft.graph.models.security.BlobEvidence;
import com.microsoft.graph.models.security.CloudApplicationEvidence;
import com.microsoft.graph.models.security.CloudLogonRequestEvidence;
import com.microsoft.graph.models.security.CloudLogonSessionEvidence;
import com.microsoft.graph.models.security.ContainerEvidence;
import com.microsoft.graph.models.security.ContainerImageEvidence;
import com.microsoft.graph.models.security.ContainerRegistryEvidence;
import com.microsoft.graph.models.security.DeviceEvidence;
import com.microsoft.graph.models.security.DnsEvidence;
import com.microsoft.graph.models.security.EvidenceRemediationStatus;
import com.microsoft.graph.models.security.EvidenceRole;
import com.microsoft.graph.models.security.EvidenceVerdict;
import com.microsoft.graph.models.security.FileEvidence;
import com.microsoft.graph.models.security.FileHashEvidence;
import com.microsoft.graph.models.security.GitHubOrganizationEvidence;
import com.microsoft.graph.models.security.GitHubRepoEvidence;
import com.microsoft.graph.models.security.GitHubUserEvidence;
import com.microsoft.graph.models.security.GoogleCloudResourceEvidence;
import com.microsoft.graph.models.security.HostLogonSessionEvidence;
import com.microsoft.graph.models.security.IoTDeviceEvidence;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.graph.models.security.KubernetesClusterEvidence;
import com.microsoft.graph.models.security.KubernetesControllerEvidence;
import com.microsoft.graph.models.security.KubernetesNamespaceEvidence;
import com.microsoft.graph.models.security.KubernetesPodEvidence;
import com.microsoft.graph.models.security.KubernetesSecretEvidence;
import com.microsoft.graph.models.security.KubernetesServiceAccountEvidence;
import com.microsoft.graph.models.security.KubernetesServiceEvidence;
import com.microsoft.graph.models.security.MailClusterEvidence;
import com.microsoft.graph.models.security.MailboxConfigurationEvidence;
import com.microsoft.graph.models.security.MailboxEvidence;
import com.microsoft.graph.models.security.MalwareEvidence;
import com.microsoft.graph.models.security.NetworkConnectionEvidence;
import com.microsoft.graph.models.security.NicEvidence;
import com.microsoft.graph.models.security.OauthApplicationEvidence;
import com.microsoft.graph.models.security.ProcessEvidence;
import com.microsoft.graph.models.security.RegistryKeyEvidence;
import com.microsoft.graph.models.security.RegistryValueEvidence;
import com.microsoft.graph.models.security.SasTokenEvidence;
import com.microsoft.graph.models.security.SecurityGroupEvidence;
import com.microsoft.graph.models.security.ServicePrincipalEvidence;
import com.microsoft.graph.models.security.SubmissionMailEvidence;
import com.microsoft.graph.models.security.UrlEvidence;
import com.microsoft.graph.models.security.UserEvidence;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class AlertEvidence
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public AlertEvidence() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static AlertEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.security.amazonResourceEvidence": {
                    return new AmazonResourceEvidence();
                }
                case "#microsoft.graph.security.analyzedMessageEvidence": {
                    return new AnalyzedMessageEvidence();
                }
                case "#microsoft.graph.security.azureResourceEvidence": {
                    return new AzureResourceEvidence();
                }
                case "#microsoft.graph.security.blobContainerEvidence": {
                    return new BlobContainerEvidence();
                }
                case "#microsoft.graph.security.blobEvidence": {
                    return new BlobEvidence();
                }
                case "#microsoft.graph.security.cloudApplicationEvidence": {
                    return new CloudApplicationEvidence();
                }
                case "#microsoft.graph.security.cloudLogonRequestEvidence": {
                    return new CloudLogonRequestEvidence();
                }
                case "#microsoft.graph.security.cloudLogonSessionEvidence": {
                    return new CloudLogonSessionEvidence();
                }
                case "#microsoft.graph.security.containerEvidence": {
                    return new ContainerEvidence();
                }
                case "#microsoft.graph.security.containerImageEvidence": {
                    return new ContainerImageEvidence();
                }
                case "#microsoft.graph.security.containerRegistryEvidence": {
                    return new ContainerRegistryEvidence();
                }
                case "#microsoft.graph.security.deviceEvidence": {
                    return new DeviceEvidence();
                }
                case "#microsoft.graph.security.dnsEvidence": {
                    return new DnsEvidence();
                }
                case "#microsoft.graph.security.fileEvidence": {
                    return new FileEvidence();
                }
                case "#microsoft.graph.security.fileHashEvidence": {
                    return new FileHashEvidence();
                }
                case "#microsoft.graph.security.gitHubOrganizationEvidence": {
                    return new GitHubOrganizationEvidence();
                }
                case "#microsoft.graph.security.gitHubRepoEvidence": {
                    return new GitHubRepoEvidence();
                }
                case "#microsoft.graph.security.gitHubUserEvidence": {
                    return new GitHubUserEvidence();
                }
                case "#microsoft.graph.security.googleCloudResourceEvidence": {
                    return new GoogleCloudResourceEvidence();
                }
                case "#microsoft.graph.security.hostLogonSessionEvidence": {
                    return new HostLogonSessionEvidence();
                }
                case "#microsoft.graph.security.ioTDeviceEvidence": {
                    return new IoTDeviceEvidence();
                }
                case "#microsoft.graph.security.ipEvidence": {
                    return new IpEvidence();
                }
                case "#microsoft.graph.security.kubernetesClusterEvidence": {
                    return new KubernetesClusterEvidence();
                }
                case "#microsoft.graph.security.kubernetesControllerEvidence": {
                    return new KubernetesControllerEvidence();
                }
                case "#microsoft.graph.security.kubernetesNamespaceEvidence": {
                    return new KubernetesNamespaceEvidence();
                }
                case "#microsoft.graph.security.kubernetesPodEvidence": {
                    return new KubernetesPodEvidence();
                }
                case "#microsoft.graph.security.kubernetesSecretEvidence": {
                    return new KubernetesSecretEvidence();
                }
                case "#microsoft.graph.security.kubernetesServiceAccountEvidence": {
                    return new KubernetesServiceAccountEvidence();
                }
                case "#microsoft.graph.security.kubernetesServiceEvidence": {
                    return new KubernetesServiceEvidence();
                }
                case "#microsoft.graph.security.mailboxConfigurationEvidence": {
                    return new MailboxConfigurationEvidence();
                }
                case "#microsoft.graph.security.mailboxEvidence": {
                    return new MailboxEvidence();
                }
                case "#microsoft.graph.security.mailClusterEvidence": {
                    return new MailClusterEvidence();
                }
                case "#microsoft.graph.security.malwareEvidence": {
                    return new MalwareEvidence();
                }
                case "#microsoft.graph.security.networkConnectionEvidence": {
                    return new NetworkConnectionEvidence();
                }
                case "#microsoft.graph.security.nicEvidence": {
                    return new NicEvidence();
                }
                case "#microsoft.graph.security.oauthApplicationEvidence": {
                    return new OauthApplicationEvidence();
                }
                case "#microsoft.graph.security.processEvidence": {
                    return new ProcessEvidence();
                }
                case "#microsoft.graph.security.registryKeyEvidence": {
                    return new RegistryKeyEvidence();
                }
                case "#microsoft.graph.security.registryValueEvidence": {
                    return new RegistryValueEvidence();
                }
                case "#microsoft.graph.security.sasTokenEvidence": {
                    return new SasTokenEvidence();
                }
                case "#microsoft.graph.security.securityGroupEvidence": {
                    return new SecurityGroupEvidence();
                }
                case "#microsoft.graph.security.servicePrincipalEvidence": {
                    return new ServicePrincipalEvidence();
                }
                case "#microsoft.graph.security.submissionMailEvidence": {
                    return new SubmissionMailEvidence();
                }
                case "#microsoft.graph.security.urlEvidence": {
                    return new UrlEvidence();
                }
                case "#microsoft.graph.security.userEvidence": {
                    return new UserEvidence();
                }
            }
        }
        return new AlertEvidence();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<String> getDetailedRoles() {
        return (List)this.backingStore.get("detailedRoles");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("detailedRoles", n -> this.setDetailedRoles(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("remediationStatus", n -> this.setRemediationStatus((EvidenceRemediationStatus)n.getEnumValue(EvidenceRemediationStatus::forValue)));
        deserializerMap.put("remediationStatusDetails", n -> this.setRemediationStatusDetails(n.getStringValue()));
        deserializerMap.put("roles", n -> this.setRoles(n.getCollectionOfEnumValues(EvidenceRole::forValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("verdict", n -> this.setVerdict((EvidenceVerdict)n.getEnumValue(EvidenceVerdict::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public EvidenceRemediationStatus getRemediationStatus() {
        return (EvidenceRemediationStatus)((Object)this.backingStore.get("remediationStatus"));
    }

    @Nullable
    public String getRemediationStatusDetails() {
        return (String)this.backingStore.get("remediationStatusDetails");
    }

    @Nullable
    public List<EvidenceRole> getRoles() {
        return (List)this.backingStore.get("roles");
    }

    @Nullable
    public List<String> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Nullable
    public EvidenceVerdict getVerdict() {
        return (EvidenceVerdict)((Object)this.backingStore.get("verdict"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfPrimitiveValues("detailedRoles", this.getDetailedRoles());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("remediationStatus", (Enum)this.getRemediationStatus());
        writer.writeStringValue("remediationStatusDetails", this.getRemediationStatusDetails());
        writer.writeCollectionOfEnumValues("roles", this.getRoles());
        writer.writeCollectionOfPrimitiveValues("tags", this.getTags());
        writer.writeEnumValue("verdict", (Enum)this.getVerdict());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDetailedRoles(@Nullable List<String> value) {
        this.backingStore.set("detailedRoles", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRemediationStatus(@Nullable EvidenceRemediationStatus value) {
        this.backingStore.set("remediationStatus", (Object)value);
    }

    public void setRemediationStatusDetails(@Nullable String value) {
        this.backingStore.set("remediationStatusDetails", (Object)value);
    }

    public void setRoles(@Nullable List<EvidenceRole> value) {
        this.backingStore.set("roles", value);
    }

    public void setTags(@Nullable List<String> value) {
        this.backingStore.set("tags", value);
    }

    public void setVerdict(@Nullable EvidenceVerdict value) {
        this.backingStore.set("verdict", (Object)value);
    }
}

