/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookIcon;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.UntypedNode;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WorkbookFilterCriteria
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WorkbookFilterCriteria() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WorkbookFilterCriteria createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WorkbookFilterCriteria();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getColor() {
        return (String)this.backingStore.get("color");
    }

    @Nullable
    public String getCriterion1() {
        return (String)this.backingStore.get("criterion1");
    }

    @Nullable
    public String getCriterion2() {
        return (String)this.backingStore.get("criterion2");
    }

    @Nullable
    public String getDynamicCriteria() {
        return (String)this.backingStore.get("dynamicCriteria");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(9);
        deserializerMap.put("color", n -> this.setColor(n.getStringValue()));
        deserializerMap.put("criterion1", n -> this.setCriterion1(n.getStringValue()));
        deserializerMap.put("criterion2", n -> this.setCriterion2(n.getStringValue()));
        deserializerMap.put("dynamicCriteria", n -> this.setDynamicCriteria(n.getStringValue()));
        deserializerMap.put("filterOn", n -> this.setFilterOn(n.getStringValue()));
        deserializerMap.put("icon", n -> this.setIcon((WorkbookIcon)n.getObjectValue(WorkbookIcon::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operator", n -> this.setOperator(n.getStringValue()));
        deserializerMap.put("values", n -> this.setValues((UntypedNode)n.getObjectValue(UntypedNode::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getFilterOn() {
        return (String)this.backingStore.get("filterOn");
    }

    @Nullable
    public WorkbookIcon getIcon() {
        return (WorkbookIcon)this.backingStore.get("icon");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOperator() {
        return (String)this.backingStore.get("operator");
    }

    @Nullable
    public UntypedNode getValues() {
        return (UntypedNode)this.backingStore.get("values");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("color", this.getColor());
        writer.writeStringValue("criterion1", this.getCriterion1());
        writer.writeStringValue("criterion2", this.getCriterion2());
        writer.writeStringValue("dynamicCriteria", this.getDynamicCriteria());
        writer.writeStringValue("filterOn", this.getFilterOn());
        writer.writeObjectValue("icon", (Parsable)this.getIcon(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("operator", this.getOperator());
        writer.writeObjectValue("values", (Parsable)this.getValues(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setColor(@Nullable String value) {
        this.backingStore.set("color", (Object)value);
    }

    public void setCriterion1(@Nullable String value) {
        this.backingStore.set("criterion1", (Object)value);
    }

    public void setCriterion2(@Nullable String value) {
        this.backingStore.set("criterion2", (Object)value);
    }

    public void setDynamicCriteria(@Nullable String value) {
        this.backingStore.set("dynamicCriteria", (Object)value);
    }

    public void setFilterOn(@Nullable String value) {
        this.backingStore.set("filterOn", (Object)value);
    }

    public void setIcon(@Nullable WorkbookIcon value) {
        this.backingStore.set("icon", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperator(@Nullable String value) {
        this.backingStore.set("operator", (Object)value);
    }

    public void setValues(@Nullable UntypedNode value) {
        this.backingStore.set("values", (Object)value);
    }
}

