/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.microsoft.graph.models.OnPremisesProvisioningError;
import com.microsoft.graph.models.Phone;
import com.microsoft.graph.models.PhysicalOfficeAddress;
import com.microsoft.graph.models.ServiceProvisioningError;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OrgContact
extends DirectoryObject
implements Parsable {
    public OrgContact() {
        this.setOdataType("#microsoft.graph.orgContact");
    }

    @Nonnull
    public static OrgContact createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OrgContact();
    }

    @Nullable
    public List<PhysicalOfficeAddress> getAddresses() {
        return (List)this.backingStore.get("addresses");
    }

    @Nullable
    public String getCompanyName() {
        return (String)this.backingStore.get("companyName");
    }

    @Nullable
    public String getDepartment() {
        return (String)this.backingStore.get("department");
    }

    @Nullable
    public List<DirectoryObject> getDirectReports() {
        return (List)this.backingStore.get("directReports");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("addresses", n -> this.setAddresses(n.getCollectionOfObjectValues(PhysicalOfficeAddress::createFromDiscriminatorValue)));
        deserializerMap.put("companyName", n -> this.setCompanyName(n.getStringValue()));
        deserializerMap.put("department", n -> this.setDepartment(n.getStringValue()));
        deserializerMap.put("directReports", n -> this.setDirectReports(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("givenName", n -> this.setGivenName(n.getStringValue()));
        deserializerMap.put("jobTitle", n -> this.setJobTitle(n.getStringValue()));
        deserializerMap.put("mail", n -> this.setMail(n.getStringValue()));
        deserializerMap.put("mailNickname", n -> this.setMailNickname(n.getStringValue()));
        deserializerMap.put("manager", n -> this.setManager((DirectoryObject)n.getObjectValue(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("memberOf", n -> this.setMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        deserializerMap.put("onPremisesLastSyncDateTime", n -> this.setOnPremisesLastSyncDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("onPremisesProvisioningErrors", n -> this.setOnPremisesProvisioningErrors(n.getCollectionOfObjectValues(OnPremisesProvisioningError::createFromDiscriminatorValue)));
        deserializerMap.put("onPremisesSyncEnabled", n -> this.setOnPremisesSyncEnabled(n.getBooleanValue()));
        deserializerMap.put("phones", n -> this.setPhones(n.getCollectionOfObjectValues(Phone::createFromDiscriminatorValue)));
        deserializerMap.put("proxyAddresses", n -> this.setProxyAddresses(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("serviceProvisioningErrors", n -> this.setServiceProvisioningErrors(n.getCollectionOfObjectValues(ServiceProvisioningError::createFromDiscriminatorValue)));
        deserializerMap.put("surname", n -> this.setSurname(n.getStringValue()));
        deserializerMap.put("transitiveMemberOf", n -> this.setTransitiveMemberOf(n.getCollectionOfObjectValues(DirectoryObject::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public String getGivenName() {
        return (String)this.backingStore.get("givenName");
    }

    @Nullable
    public String getJobTitle() {
        return (String)this.backingStore.get("jobTitle");
    }

    @Nullable
    public String getMail() {
        return (String)this.backingStore.get("mail");
    }

    @Nullable
    public String getMailNickname() {
        return (String)this.backingStore.get("mailNickname");
    }

    @Nullable
    public DirectoryObject getManager() {
        return (DirectoryObject)this.backingStore.get("manager");
    }

    @Nullable
    public List<DirectoryObject> getMemberOf() {
        return (List)this.backingStore.get("memberOf");
    }

    @Nullable
    public OffsetDateTime getOnPremisesLastSyncDateTime() {
        return (OffsetDateTime)this.backingStore.get("onPremisesLastSyncDateTime");
    }

    @Nullable
    public List<OnPremisesProvisioningError> getOnPremisesProvisioningErrors() {
        return (List)this.backingStore.get("onPremisesProvisioningErrors");
    }

    @Nullable
    public Boolean getOnPremisesSyncEnabled() {
        return (Boolean)this.backingStore.get("onPremisesSyncEnabled");
    }

    @Nullable
    public List<Phone> getPhones() {
        return (List)this.backingStore.get("phones");
    }

    @Nullable
    public List<String> getProxyAddresses() {
        return (List)this.backingStore.get("proxyAddresses");
    }

    @Nullable
    public List<ServiceProvisioningError> getServiceProvisioningErrors() {
        return (List)this.backingStore.get("serviceProvisioningErrors");
    }

    @Nullable
    public String getSurname() {
        return (String)this.backingStore.get("surname");
    }

    @Nullable
    public List<DirectoryObject> getTransitiveMemberOf() {
        return (List)this.backingStore.get("transitiveMemberOf");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("addresses", this.getAddresses());
        writer.writeStringValue("companyName", this.getCompanyName());
        writer.writeStringValue("department", this.getDepartment());
        writer.writeCollectionOfObjectValues("directReports", this.getDirectReports());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("givenName", this.getGivenName());
        writer.writeStringValue("jobTitle", this.getJobTitle());
        writer.writeStringValue("mail", this.getMail());
        writer.writeStringValue("mailNickname", this.getMailNickname());
        writer.writeObjectValue("manager", (Parsable)this.getManager(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("memberOf", this.getMemberOf());
        writer.writeOffsetDateTimeValue("onPremisesLastSyncDateTime", this.getOnPremisesLastSyncDateTime());
        writer.writeCollectionOfObjectValues("onPremisesProvisioningErrors", this.getOnPremisesProvisioningErrors());
        writer.writeBooleanValue("onPremisesSyncEnabled", this.getOnPremisesSyncEnabled());
        writer.writeCollectionOfObjectValues("phones", this.getPhones());
        writer.writeCollectionOfPrimitiveValues("proxyAddresses", this.getProxyAddresses());
        writer.writeCollectionOfObjectValues("serviceProvisioningErrors", this.getServiceProvisioningErrors());
        writer.writeStringValue("surname", this.getSurname());
        writer.writeCollectionOfObjectValues("transitiveMemberOf", this.getTransitiveMemberOf());
    }

    public void setAddresses(@Nullable List<PhysicalOfficeAddress> value) {
        this.backingStore.set("addresses", value);
    }

    public void setCompanyName(@Nullable String value) {
        this.backingStore.set("companyName", (Object)value);
    }

    public void setDepartment(@Nullable String value) {
        this.backingStore.set("department", (Object)value);
    }

    public void setDirectReports(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("directReports", value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setGivenName(@Nullable String value) {
        this.backingStore.set("givenName", (Object)value);
    }

    public void setJobTitle(@Nullable String value) {
        this.backingStore.set("jobTitle", (Object)value);
    }

    public void setMail(@Nullable String value) {
        this.backingStore.set("mail", (Object)value);
    }

    public void setMailNickname(@Nullable String value) {
        this.backingStore.set("mailNickname", (Object)value);
    }

    public void setManager(@Nullable DirectoryObject value) {
        this.backingStore.set("manager", (Object)value);
    }

    public void setMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("memberOf", value);
    }

    public void setOnPremisesLastSyncDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("onPremisesLastSyncDateTime", (Object)value);
    }

    public void setOnPremisesProvisioningErrors(@Nullable List<OnPremisesProvisioningError> value) {
        this.backingStore.set("onPremisesProvisioningErrors", value);
    }

    public void setOnPremisesSyncEnabled(@Nullable Boolean value) {
        this.backingStore.set("onPremisesSyncEnabled", (Object)value);
    }

    public void setPhones(@Nullable List<Phone> value) {
        this.backingStore.set("phones", value);
    }

    public void setProxyAddresses(@Nullable List<String> value) {
        this.backingStore.set("proxyAddresses", value);
    }

    public void setServiceProvisioningErrors(@Nullable List<ServiceProvisioningError> value) {
        this.backingStore.set("serviceProvisioningErrors", value);
    }

    public void setSurname(@Nullable String value) {
        this.backingStore.set("surname", (Object)value);
    }

    public void setTransitiveMemberOf(@Nullable List<DirectoryObject> value) {
        this.backingStore.set("transitiveMemberOf", value);
    }
}

