/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingCustomerInformationBase;
import com.microsoft.graph.models.BookingPriceType;
import com.microsoft.graph.models.BookingReminder;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.Location;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingAppointment
extends Entity
implements Parsable {
    @Nonnull
    public static BookingAppointment createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingAppointment();
    }

    @Nullable
    public String getAdditionalInformation() {
        return (String)this.backingStore.get("additionalInformation");
    }

    @Nullable
    public String getAnonymousJoinWebUrl() {
        return (String)this.backingStore.get("anonymousJoinWebUrl");
    }

    @Nullable
    public String getAppointmentLabel() {
        return (String)this.backingStore.get("appointmentLabel");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getCustomerEmailAddress() {
        return (String)this.backingStore.get("customerEmailAddress");
    }

    @Nullable
    public String getCustomerName() {
        return (String)this.backingStore.get("customerName");
    }

    @Nullable
    public String getCustomerNotes() {
        return (String)this.backingStore.get("customerNotes");
    }

    @Nullable
    public String getCustomerPhone() {
        return (String)this.backingStore.get("customerPhone");
    }

    @Nullable
    public List<BookingCustomerInformationBase> getCustomers() {
        return (List)this.backingStore.get("customers");
    }

    @Nullable
    public String getCustomerTimeZone() {
        return (String)this.backingStore.get("customerTimeZone");
    }

    @Nullable
    public PeriodAndDuration getDuration() {
        return (PeriodAndDuration)this.backingStore.get("duration");
    }

    @Nullable
    public DateTimeTimeZone getEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("endDateTime");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("additionalInformation", n -> this.setAdditionalInformation(n.getStringValue()));
        deserializerMap.put("anonymousJoinWebUrl", n -> this.setAnonymousJoinWebUrl(n.getStringValue()));
        deserializerMap.put("appointmentLabel", n -> this.setAppointmentLabel(n.getStringValue()));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customerEmailAddress", n -> this.setCustomerEmailAddress(n.getStringValue()));
        deserializerMap.put("customerName", n -> this.setCustomerName(n.getStringValue()));
        deserializerMap.put("customerNotes", n -> this.setCustomerNotes(n.getStringValue()));
        deserializerMap.put("customerPhone", n -> this.setCustomerPhone(n.getStringValue()));
        deserializerMap.put("customers", n -> this.setCustomers(n.getCollectionOfObjectValues(BookingCustomerInformationBase::createFromDiscriminatorValue)));
        deserializerMap.put("customerTimeZone", n -> this.setCustomerTimeZone(n.getStringValue()));
        deserializerMap.put("duration", n -> this.setDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("endDateTime", n -> this.setEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("filledAttendeesCount", n -> this.setFilledAttendeesCount(n.getIntegerValue()));
        deserializerMap.put("isCustomerAllowedToManageBooking", n -> this.setIsCustomerAllowedToManageBooking(n.getBooleanValue()));
        deserializerMap.put("isLocationOnline", n -> this.setIsLocationOnline(n.getBooleanValue()));
        deserializerMap.put("joinWebUrl", n -> this.setJoinWebUrl(n.getStringValue()));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("maximumAttendeesCount", n -> this.setMaximumAttendeesCount(n.getIntegerValue()));
        deserializerMap.put("optOutOfCustomerEmail", n -> this.setOptOutOfCustomerEmail(n.getBooleanValue()));
        deserializerMap.put("postBuffer", n -> this.setPostBuffer(n.getPeriodAndDurationValue()));
        deserializerMap.put("preBuffer", n -> this.setPreBuffer(n.getPeriodAndDurationValue()));
        deserializerMap.put("price", n -> this.setPrice(n.getDoubleValue()));
        deserializerMap.put("priceType", n -> this.setPriceType((BookingPriceType)n.getEnumValue(BookingPriceType::forValue)));
        deserializerMap.put("reminders", n -> this.setReminders(n.getCollectionOfObjectValues(BookingReminder::createFromDiscriminatorValue)));
        deserializerMap.put("selfServiceAppointmentId", n -> this.setSelfServiceAppointmentId(n.getStringValue()));
        deserializerMap.put("serviceId", n -> this.setServiceId(n.getStringValue()));
        deserializerMap.put("serviceLocation", n -> this.setServiceLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("serviceName", n -> this.setServiceName(n.getStringValue()));
        deserializerMap.put("serviceNotes", n -> this.setServiceNotes(n.getStringValue()));
        deserializerMap.put("smsNotificationsEnabled", n -> this.setSmsNotificationsEnabled(n.getBooleanValue()));
        deserializerMap.put("staffMemberIds", n -> this.setStaffMemberIds(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Integer getFilledAttendeesCount() {
        return (Integer)this.backingStore.get("filledAttendeesCount");
    }

    @Nullable
    public Boolean getIsCustomerAllowedToManageBooking() {
        return (Boolean)this.backingStore.get("isCustomerAllowedToManageBooking");
    }

    @Nullable
    public Boolean getIsLocationOnline() {
        return (Boolean)this.backingStore.get("isLocationOnline");
    }

    @Nullable
    public String getJoinWebUrl() {
        return (String)this.backingStore.get("joinWebUrl");
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public Integer getMaximumAttendeesCount() {
        return (Integer)this.backingStore.get("maximumAttendeesCount");
    }

    @Nullable
    public Boolean getOptOutOfCustomerEmail() {
        return (Boolean)this.backingStore.get("optOutOfCustomerEmail");
    }

    @Nullable
    public PeriodAndDuration getPostBuffer() {
        return (PeriodAndDuration)this.backingStore.get("postBuffer");
    }

    @Nullable
    public PeriodAndDuration getPreBuffer() {
        return (PeriodAndDuration)this.backingStore.get("preBuffer");
    }

    @Nullable
    public Double getPrice() {
        return (Double)this.backingStore.get("price");
    }

    @Nullable
    public BookingPriceType getPriceType() {
        return (BookingPriceType)((Object)this.backingStore.get("priceType"));
    }

    @Nullable
    public List<BookingReminder> getReminders() {
        return (List)this.backingStore.get("reminders");
    }

    @Nullable
    public String getSelfServiceAppointmentId() {
        return (String)this.backingStore.get("selfServiceAppointmentId");
    }

    @Nullable
    public String getServiceId() {
        return (String)this.backingStore.get("serviceId");
    }

    @Nullable
    public Location getServiceLocation() {
        return (Location)this.backingStore.get("serviceLocation");
    }

    @Nullable
    public String getServiceName() {
        return (String)this.backingStore.get("serviceName");
    }

    @Nullable
    public String getServiceNotes() {
        return (String)this.backingStore.get("serviceNotes");
    }

    @Nullable
    public Boolean getSmsNotificationsEnabled() {
        return (Boolean)this.backingStore.get("smsNotificationsEnabled");
    }

    @Nullable
    public List<String> getStaffMemberIds() {
        return (List)this.backingStore.get("staffMemberIds");
    }

    @Nullable
    public DateTimeTimeZone getStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("startDateTime");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("additionalInformation", this.getAdditionalInformation());
        writer.writeStringValue("anonymousJoinWebUrl", this.getAnonymousJoinWebUrl());
        writer.writeStringValue("appointmentLabel", this.getAppointmentLabel());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("customerEmailAddress", this.getCustomerEmailAddress());
        writer.writeStringValue("customerName", this.getCustomerName());
        writer.writeStringValue("customerNotes", this.getCustomerNotes());
        writer.writeStringValue("customerPhone", this.getCustomerPhone());
        writer.writeCollectionOfObjectValues("customers", this.getCustomers());
        writer.writeStringValue("customerTimeZone", this.getCustomerTimeZone());
        writer.writeObjectValue("endDateTime", (Parsable)this.getEndDateTime(), new Parsable[0]);
        writer.writeBooleanValue("isCustomerAllowedToManageBooking", this.getIsCustomerAllowedToManageBooking());
        writer.writeBooleanValue("isLocationOnline", this.getIsLocationOnline());
        writer.writeStringValue("joinWebUrl", this.getJoinWebUrl());
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeIntegerValue("maximumAttendeesCount", this.getMaximumAttendeesCount());
        writer.writeBooleanValue("optOutOfCustomerEmail", this.getOptOutOfCustomerEmail());
        writer.writePeriodAndDurationValue("postBuffer", this.getPostBuffer());
        writer.writePeriodAndDurationValue("preBuffer", this.getPreBuffer());
        writer.writeDoubleValue("price", this.getPrice());
        writer.writeEnumValue("priceType", (Enum)this.getPriceType());
        writer.writeCollectionOfObjectValues("reminders", this.getReminders());
        writer.writeStringValue("selfServiceAppointmentId", this.getSelfServiceAppointmentId());
        writer.writeStringValue("serviceId", this.getServiceId());
        writer.writeObjectValue("serviceLocation", (Parsable)this.getServiceLocation(), new Parsable[0]);
        writer.writeStringValue("serviceName", this.getServiceName());
        writer.writeStringValue("serviceNotes", this.getServiceNotes());
        writer.writeBooleanValue("smsNotificationsEnabled", this.getSmsNotificationsEnabled());
        writer.writeCollectionOfPrimitiveValues("staffMemberIds", this.getStaffMemberIds());
        writer.writeObjectValue("startDateTime", (Parsable)this.getStartDateTime(), new Parsable[0]);
    }

    public void setAdditionalInformation(@Nullable String value) {
        this.backingStore.set("additionalInformation", (Object)value);
    }

    public void setAnonymousJoinWebUrl(@Nullable String value) {
        this.backingStore.set("anonymousJoinWebUrl", (Object)value);
    }

    public void setAppointmentLabel(@Nullable String value) {
        this.backingStore.set("appointmentLabel", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomerEmailAddress(@Nullable String value) {
        this.backingStore.set("customerEmailAddress", (Object)value);
    }

    public void setCustomerName(@Nullable String value) {
        this.backingStore.set("customerName", (Object)value);
    }

    public void setCustomerNotes(@Nullable String value) {
        this.backingStore.set("customerNotes", (Object)value);
    }

    public void setCustomerPhone(@Nullable String value) {
        this.backingStore.set("customerPhone", (Object)value);
    }

    public void setCustomers(@Nullable List<BookingCustomerInformationBase> value) {
        this.backingStore.set("customers", value);
    }

    public void setCustomerTimeZone(@Nullable String value) {
        this.backingStore.set("customerTimeZone", (Object)value);
    }

    public void setDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("duration", (Object)value);
    }

    public void setEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setFilledAttendeesCount(@Nullable Integer value) {
        this.backingStore.set("filledAttendeesCount", (Object)value);
    }

    public void setIsCustomerAllowedToManageBooking(@Nullable Boolean value) {
        this.backingStore.set("isCustomerAllowedToManageBooking", (Object)value);
    }

    public void setIsLocationOnline(@Nullable Boolean value) {
        this.backingStore.set("isLocationOnline", (Object)value);
    }

    public void setJoinWebUrl(@Nullable String value) {
        this.backingStore.set("joinWebUrl", (Object)value);
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setMaximumAttendeesCount(@Nullable Integer value) {
        this.backingStore.set("maximumAttendeesCount", (Object)value);
    }

    public void setOptOutOfCustomerEmail(@Nullable Boolean value) {
        this.backingStore.set("optOutOfCustomerEmail", (Object)value);
    }

    public void setPostBuffer(@Nullable PeriodAndDuration value) {
        this.backingStore.set("postBuffer", (Object)value);
    }

    public void setPreBuffer(@Nullable PeriodAndDuration value) {
        this.backingStore.set("preBuffer", (Object)value);
    }

    public void setPrice(@Nullable Double value) {
        this.backingStore.set("price", (Object)value);
    }

    public void setPriceType(@Nullable BookingPriceType value) {
        this.backingStore.set("priceType", (Object)value);
    }

    public void setReminders(@Nullable List<BookingReminder> value) {
        this.backingStore.set("reminders", value);
    }

    public void setSelfServiceAppointmentId(@Nullable String value) {
        this.backingStore.set("selfServiceAppointmentId", (Object)value);
    }

    public void setServiceId(@Nullable String value) {
        this.backingStore.set("serviceId", (Object)value);
    }

    public void setServiceLocation(@Nullable Location value) {
        this.backingStore.set("serviceLocation", (Object)value);
    }

    public void setServiceName(@Nullable String value) {
        this.backingStore.set("serviceName", (Object)value);
    }

    public void setServiceNotes(@Nullable String value) {
        this.backingStore.set("serviceNotes", (Object)value);
    }

    public void setSmsNotificationsEnabled(@Nullable Boolean value) {
        this.backingStore.set("smsNotificationsEnabled", (Object)value);
    }

    public void setStaffMemberIds(@Nullable List<String> value) {
        this.backingStore.set("staffMemberIds", value);
    }

    public void setStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("startDateTime", (Object)value);
    }
}

