/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.WindowsMalwareSeverity;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsMalwareSeverityCount
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WindowsMalwareSeverityCount() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WindowsMalwareSeverityCount createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareSeverityCount();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getDistinctMalwareCount() {
        return (Integer)this.backingStore.get("distinctMalwareCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("distinctMalwareCount", n -> this.setDistinctMalwareCount(n.getIntegerValue()));
        deserializerMap.put("lastUpdateDateTime", n -> this.setLastUpdateDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("malwareDetectionCount", n -> this.setMalwareDetectionCount(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("severity", n -> this.setSeverity((WindowsMalwareSeverity)n.getEnumValue(WindowsMalwareSeverity::forValue)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdateDateTime");
    }

    @Nullable
    public Integer getMalwareDetectionCount() {
        return (Integer)this.backingStore.get("malwareDetectionCount");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public WindowsMalwareSeverity getSeverity() {
        return (WindowsMalwareSeverity)((Object)this.backingStore.get("severity"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("distinctMalwareCount", this.getDistinctMalwareCount());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeIntegerValue("malwareDetectionCount", this.getMalwareDetectionCount());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("severity", (Enum)this.getSeverity());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDistinctMalwareCount(@Nullable Integer value) {
        this.backingStore.set("distinctMalwareCount", (Object)value);
    }

    public void setLastUpdateDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", (Object)value);
    }

    public void setMalwareDetectionCount(@Nullable Integer value) {
        this.backingStore.set("malwareDetectionCount", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSeverity(@Nullable WindowsMalwareSeverity value) {
        this.backingStore.set("severity", (Object)value);
    }
}

