/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceProtectionOverview
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceProtectionOverview() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceProtectionOverview createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceProtectionOverview();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getCleanDeviceCount() {
        return (Integer)this.backingStore.get("cleanDeviceCount");
    }

    @Nullable
    public Integer getCriticalFailuresDeviceCount() {
        return (Integer)this.backingStore.get("criticalFailuresDeviceCount");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(12);
        deserializerMap.put("cleanDeviceCount", n -> this.setCleanDeviceCount(n.getIntegerValue()));
        deserializerMap.put("criticalFailuresDeviceCount", n -> this.setCriticalFailuresDeviceCount(n.getIntegerValue()));
        deserializerMap.put("inactiveThreatAgentDeviceCount", n -> this.setInactiveThreatAgentDeviceCount(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("pendingFullScanDeviceCount", n -> this.setPendingFullScanDeviceCount(n.getIntegerValue()));
        deserializerMap.put("pendingManualStepsDeviceCount", n -> this.setPendingManualStepsDeviceCount(n.getIntegerValue()));
        deserializerMap.put("pendingOfflineScanDeviceCount", n -> this.setPendingOfflineScanDeviceCount(n.getIntegerValue()));
        deserializerMap.put("pendingQuickScanDeviceCount", n -> this.setPendingQuickScanDeviceCount(n.getIntegerValue()));
        deserializerMap.put("pendingRestartDeviceCount", n -> this.setPendingRestartDeviceCount(n.getIntegerValue()));
        deserializerMap.put("pendingSignatureUpdateDeviceCount", n -> this.setPendingSignatureUpdateDeviceCount(n.getIntegerValue()));
        deserializerMap.put("totalReportedDeviceCount", n -> this.setTotalReportedDeviceCount(n.getIntegerValue()));
        deserializerMap.put("unknownStateThreatAgentDeviceCount", n -> this.setUnknownStateThreatAgentDeviceCount(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public Integer getInactiveThreatAgentDeviceCount() {
        return (Integer)this.backingStore.get("inactiveThreatAgentDeviceCount");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getPendingFullScanDeviceCount() {
        return (Integer)this.backingStore.get("pendingFullScanDeviceCount");
    }

    @Nullable
    public Integer getPendingManualStepsDeviceCount() {
        return (Integer)this.backingStore.get("pendingManualStepsDeviceCount");
    }

    @Nullable
    public Integer getPendingOfflineScanDeviceCount() {
        return (Integer)this.backingStore.get("pendingOfflineScanDeviceCount");
    }

    @Nullable
    public Integer getPendingQuickScanDeviceCount() {
        return (Integer)this.backingStore.get("pendingQuickScanDeviceCount");
    }

    @Nullable
    public Integer getPendingRestartDeviceCount() {
        return (Integer)this.backingStore.get("pendingRestartDeviceCount");
    }

    @Nullable
    public Integer getPendingSignatureUpdateDeviceCount() {
        return (Integer)this.backingStore.get("pendingSignatureUpdateDeviceCount");
    }

    @Nullable
    public Integer getTotalReportedDeviceCount() {
        return (Integer)this.backingStore.get("totalReportedDeviceCount");
    }

    @Nullable
    public Integer getUnknownStateThreatAgentDeviceCount() {
        return (Integer)this.backingStore.get("unknownStateThreatAgentDeviceCount");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("cleanDeviceCount", this.getCleanDeviceCount());
        writer.writeIntegerValue("criticalFailuresDeviceCount", this.getCriticalFailuresDeviceCount());
        writer.writeIntegerValue("inactiveThreatAgentDeviceCount", this.getInactiveThreatAgentDeviceCount());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("pendingFullScanDeviceCount", this.getPendingFullScanDeviceCount());
        writer.writeIntegerValue("pendingManualStepsDeviceCount", this.getPendingManualStepsDeviceCount());
        writer.writeIntegerValue("pendingOfflineScanDeviceCount", this.getPendingOfflineScanDeviceCount());
        writer.writeIntegerValue("pendingQuickScanDeviceCount", this.getPendingQuickScanDeviceCount());
        writer.writeIntegerValue("pendingRestartDeviceCount", this.getPendingRestartDeviceCount());
        writer.writeIntegerValue("pendingSignatureUpdateDeviceCount", this.getPendingSignatureUpdateDeviceCount());
        writer.writeIntegerValue("totalReportedDeviceCount", this.getTotalReportedDeviceCount());
        writer.writeIntegerValue("unknownStateThreatAgentDeviceCount", this.getUnknownStateThreatAgentDeviceCount());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCleanDeviceCount(@Nullable Integer value) {
        this.backingStore.set("cleanDeviceCount", (Object)value);
    }

    public void setCriticalFailuresDeviceCount(@Nullable Integer value) {
        this.backingStore.set("criticalFailuresDeviceCount", (Object)value);
    }

    public void setInactiveThreatAgentDeviceCount(@Nullable Integer value) {
        this.backingStore.set("inactiveThreatAgentDeviceCount", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPendingFullScanDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingFullScanDeviceCount", (Object)value);
    }

    public void setPendingManualStepsDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingManualStepsDeviceCount", (Object)value);
    }

    public void setPendingOfflineScanDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingOfflineScanDeviceCount", (Object)value);
    }

    public void setPendingQuickScanDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingQuickScanDeviceCount", (Object)value);
    }

    public void setPendingRestartDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingRestartDeviceCount", (Object)value);
    }

    public void setPendingSignatureUpdateDeviceCount(@Nullable Integer value) {
        this.backingStore.set("pendingSignatureUpdateDeviceCount", (Object)value);
    }

    public void setTotalReportedDeviceCount(@Nullable Integer value) {
        this.backingStore.set("totalReportedDeviceCount", (Object)value);
    }

    public void setUnknownStateThreatAgentDeviceCount(@Nullable Integer value) {
        this.backingStore.set("unknownStateThreatAgentDeviceCount", (Object)value);
    }
}

