/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.reports.partners.billing.manifests;

import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.models.partners.billing.Manifest;
import com.microsoft.graph.models.partners.billing.ManifestCollectionResponse;
import com.microsoft.graph.reports.partners.billing.manifests.count.CountRequestBuilder;
import com.microsoft.graph.reports.partners.billing.manifests.item.ManifestItemRequestBuilder;
import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ManifestsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public CountRequestBuilder count() {
        return new CountRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nonnull
    public ManifestItemRequestBuilder byManifestId(@Nonnull String manifestId) {
        Objects.requireNonNull(manifestId);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("manifest%2Did", manifestId);
        return new ManifestItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public ManifestsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/reports/partners/billing/manifests{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}", pathParameters);
    }

    public ManifestsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/reports/partners/billing/manifests{?%24count,%24expand,%24filter,%24orderby,%24search,%24select,%24skip,%24top}", rawUrl);
    }

    @Nullable
    public ManifestCollectionResponse get() {
        return this.get(null);
    }

    @Nullable
    public ManifestCollectionResponse get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (ManifestCollectionResponse)this.requestAdapter.send(requestInfo, errorMapping, ManifestCollectionResponse::createFromDiscriminatorValue);
    }

    @Nullable
    public Manifest post(@Nonnull Manifest body) {
        return this.post(body, null);
    }

    @Nullable
    public Manifest post(@Nonnull Manifest body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("4XX", ODataError::createFromDiscriminatorValue);
        errorMapping.put("5XX", ODataError::createFromDiscriminatorValue);
        return (Manifest)this.requestAdapter.send(requestInfo, errorMapping, Manifest::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull Manifest body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull Manifest body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public ManifestsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new ManifestsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Boolean count;
        @Nullable
        public String[] expand;
        @Nullable
        public String filter;
        @Nullable
        public String[] orderby;
        @Nullable
        public String search;
        @Nullable
        public String[] select;
        @Nullable
        public Integer skip;
        @Nullable
        public Integer top;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("%24count", this.count);
            allQueryParams.put("%24filter", this.filter);
            allQueryParams.put("%24search", this.search);
            allQueryParams.put("%24skip", this.skip);
            allQueryParams.put("%24top", this.top);
            allQueryParams.put("%24expand", this.expand);
            allQueryParams.put("%24orderby", this.orderby);
            allQueryParams.put("%24select", this.select);
            return allQueryParams;
        }
    }
}

