/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.RiskDetail;
import com.microsoft.graph.models.RiskLevel;
import com.microsoft.graph.models.RiskState;
import com.microsoft.graph.models.RiskyUserHistoryItem;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class RiskyUser
extends Entity
implements Parsable {
    @Nonnull
    public static RiskyUser createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.riskyUserHistoryItem": {
                    return new RiskyUserHistoryItem();
                }
            }
        }
        return new RiskyUser();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("history", n -> this.setHistory(n.getCollectionOfObjectValues(RiskyUserHistoryItem::createFromDiscriminatorValue)));
        deserializerMap.put("isDeleted", n -> this.setIsDeleted(n.getBooleanValue()));
        deserializerMap.put("isProcessing", n -> this.setIsProcessing(n.getBooleanValue()));
        deserializerMap.put("riskDetail", n -> this.setRiskDetail((RiskDetail)n.getEnumValue(RiskDetail::forValue)));
        deserializerMap.put("riskLastUpdatedDateTime", n -> this.setRiskLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("riskLevel", n -> this.setRiskLevel((RiskLevel)n.getEnumValue(RiskLevel::forValue)));
        deserializerMap.put("riskState", n -> this.setRiskState((RiskState)n.getEnumValue(RiskState::forValue)));
        deserializerMap.put("userDisplayName", n -> this.setUserDisplayName(n.getStringValue()));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public List<RiskyUserHistoryItem> getHistory() {
        return (List)this.backingStore.get("history");
    }

    @Nullable
    public Boolean getIsDeleted() {
        return (Boolean)this.backingStore.get("isDeleted");
    }

    @Nullable
    public Boolean getIsProcessing() {
        return (Boolean)this.backingStore.get("isProcessing");
    }

    @Nullable
    public RiskDetail getRiskDetail() {
        return (RiskDetail)((Object)this.backingStore.get("riskDetail"));
    }

    @Nullable
    public OffsetDateTime getRiskLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("riskLastUpdatedDateTime");
    }

    @Nullable
    public RiskLevel getRiskLevel() {
        return (RiskLevel)((Object)this.backingStore.get("riskLevel"));
    }

    @Nullable
    public RiskState getRiskState() {
        return (RiskState)((Object)this.backingStore.get("riskState"));
    }

    @Nullable
    public String getUserDisplayName() {
        return (String)this.backingStore.get("userDisplayName");
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("history", this.getHistory());
        writer.writeBooleanValue("isDeleted", this.getIsDeleted());
        writer.writeBooleanValue("isProcessing", this.getIsProcessing());
        writer.writeEnumValue("riskDetail", (Enum)this.getRiskDetail());
        writer.writeOffsetDateTimeValue("riskLastUpdatedDateTime", this.getRiskLastUpdatedDateTime());
        writer.writeEnumValue("riskLevel", (Enum)this.getRiskLevel());
        writer.writeEnumValue("riskState", (Enum)this.getRiskState());
        writer.writeStringValue("userDisplayName", this.getUserDisplayName());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
    }

    public void setHistory(@Nullable List<RiskyUserHistoryItem> value) {
        this.backingStore.set("history", value);
    }

    public void setIsDeleted(@Nullable Boolean value) {
        this.backingStore.set("isDeleted", (Object)value);
    }

    public void setIsProcessing(@Nullable Boolean value) {
        this.backingStore.set("isProcessing", (Object)value);
    }

    public void setRiskDetail(@Nullable RiskDetail value) {
        this.backingStore.set("riskDetail", (Object)value);
    }

    public void setRiskLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("riskLastUpdatedDateTime", (Object)value);
    }

    public void setRiskLevel(@Nullable RiskLevel value) {
        this.backingStore.set("riskLevel", (Object)value);
    }

    public void setRiskState(@Nullable RiskState value) {
        this.backingStore.set("riskState", (Object)value);
    }

    public void setUserDisplayName(@Nullable String value) {
        this.backingStore.set("userDisplayName", (Object)value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }
}

