/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventMessageRequest;
import com.microsoft.graph.models.EventMessageResponse;
import com.microsoft.graph.models.EventType;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.MeetingMessageType;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EventMessage
extends Message
implements Parsable {
    public EventMessage() {
        this.setOdataType("#microsoft.graph.eventMessage");
    }

    @Nonnull
    public static EventMessage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.eventMessageRequest": {
                    return new EventMessageRequest();
                }
                case "#microsoft.graph.eventMessageResponse": {
                    return new EventMessageResponse();
                }
            }
        }
        return new EventMessage();
    }

    @Nullable
    public DateTimeTimeZone getEndDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("endDateTime");
    }

    @Nullable
    public Event getEvent() {
        return (Event)this.backingStore.get("event");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("endDateTime", n -> this.setEndDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("event", n -> this.setEvent((Event)n.getObjectValue(Event::createFromDiscriminatorValue)));
        deserializerMap.put("isAllDay", n -> this.setIsAllDay(n.getBooleanValue()));
        deserializerMap.put("isDelegated", n -> this.setIsDelegated(n.getBooleanValue()));
        deserializerMap.put("isOutOfDate", n -> this.setIsOutOfDate(n.getBooleanValue()));
        deserializerMap.put("location", n -> this.setLocation((Location)n.getObjectValue(Location::createFromDiscriminatorValue)));
        deserializerMap.put("meetingMessageType", n -> this.setMeetingMessageType((MeetingMessageType)n.getEnumValue(MeetingMessageType::forValue)));
        deserializerMap.put("recurrence", n -> this.setRecurrence((PatternedRecurrence)n.getObjectValue(PatternedRecurrence::createFromDiscriminatorValue)));
        deserializerMap.put("startDateTime", n -> this.setStartDateTime((DateTimeTimeZone)n.getObjectValue(DateTimeTimeZone::createFromDiscriminatorValue)));
        deserializerMap.put("type", n -> this.setType((EventType)n.getEnumValue(EventType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsAllDay() {
        return (Boolean)this.backingStore.get("isAllDay");
    }

    @Nullable
    public Boolean getIsDelegated() {
        return (Boolean)this.backingStore.get("isDelegated");
    }

    @Nullable
    public Boolean getIsOutOfDate() {
        return (Boolean)this.backingStore.get("isOutOfDate");
    }

    @Nullable
    public Location getLocation() {
        return (Location)this.backingStore.get("location");
    }

    @Nullable
    public MeetingMessageType getMeetingMessageType() {
        return (MeetingMessageType)((Object)this.backingStore.get("meetingMessageType"));
    }

    @Nullable
    public PatternedRecurrence getRecurrence() {
        return (PatternedRecurrence)this.backingStore.get("recurrence");
    }

    @Nullable
    public DateTimeTimeZone getStartDateTime() {
        return (DateTimeTimeZone)this.backingStore.get("startDateTime");
    }

    @Nullable
    public EventType getType() {
        return (EventType)((Object)this.backingStore.get("type"));
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("endDateTime", (Parsable)this.getEndDateTime(), new Parsable[0]);
        writer.writeObjectValue("event", (Parsable)this.getEvent(), new Parsable[0]);
        writer.writeBooleanValue("isAllDay", this.getIsAllDay());
        writer.writeBooleanValue("isDelegated", this.getIsDelegated());
        writer.writeBooleanValue("isOutOfDate", this.getIsOutOfDate());
        writer.writeObjectValue("location", (Parsable)this.getLocation(), new Parsable[0]);
        writer.writeEnumValue("meetingMessageType", (Enum)this.getMeetingMessageType());
        writer.writeObjectValue("recurrence", (Parsable)this.getRecurrence(), new Parsable[0]);
        writer.writeObjectValue("startDateTime", (Parsable)this.getStartDateTime(), new Parsable[0]);
        writer.writeEnumValue("type", (Enum)this.getType());
    }

    public void setEndDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("endDateTime", (Object)value);
    }

    public void setEvent(@Nullable Event value) {
        this.backingStore.set("event", (Object)value);
    }

    public void setIsAllDay(@Nullable Boolean value) {
        this.backingStore.set("isAllDay", (Object)value);
    }

    public void setIsDelegated(@Nullable Boolean value) {
        this.backingStore.set("isDelegated", (Object)value);
    }

    public void setIsOutOfDate(@Nullable Boolean value) {
        this.backingStore.set("isOutOfDate", (Object)value);
    }

    public void setLocation(@Nullable Location value) {
        this.backingStore.set("location", (Object)value);
    }

    public void setMeetingMessageType(@Nullable MeetingMessageType value) {
        this.backingStore.set("meetingMessageType", (Object)value);
    }

    public void setRecurrence(@Nullable PatternedRecurrence value) {
        this.backingStore.set("recurrence", (Object)value);
    }

    public void setStartDateTime(@Nullable DateTimeTimeZone value) {
        this.backingStore.set("startDateTime", (Object)value);
    }

    public void setType(@Nullable EventType value) {
        this.backingStore.set("type", (Object)value);
    }
}

