package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
/**
 * Malware category device count
 */
@jakarta.annotation.Generated("com.microsoft.kiota")
public class WindowsMalwareCategoryCount implements AdditionalDataHolder, BackedModel, Parsable {
    /**
     * Stores model information.
     */
    @jakarta.annotation.Nonnull
    protected BackingStore backingStore;
    /**
     * Instantiates a new WindowsMalwareCategoryCount and sets the default values.
     */
    public WindowsMalwareCategoryCount() {
        this.backingStore = BackingStoreFactorySingleton.instance.createBackingStore();
        this.setAdditionalData(new HashMap<>());
    }
    /**
     * Creates a new instance of the appropriate class based on discriminator value
     * @param parseNode The parse node to use to read the discriminator value and create the object
     * @return a WindowsMalwareCategoryCount
     */
    @jakarta.annotation.Nonnull
    public static WindowsMalwareCategoryCount createFromDiscriminatorValue(@jakarta.annotation.Nonnull final ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsMalwareCategoryCount();
    }
    /**
     * Gets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
     * @return a Integer
     */
    @jakarta.annotation.Nullable
    public Integer getActiveMalwareDetectionCount() {
        return this.backingStore.get("activeMalwareDetectionCount");
    }
    /**
     * Gets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @return a Map<String, Object>
     */
    @jakarta.annotation.Nonnull
    public Map<String, Object> getAdditionalData() {
        Map<String, Object> value = this.backingStore.get("additionalData");
        if(value == null) {
            value = new HashMap<>();
            this.setAdditionalData(value);
        }
        return value;
    }
    /**
     * Gets the backingStore property value. Stores model information.
     * @return a BackingStore
     */
    @jakarta.annotation.Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }
    /**
     * Gets the category property value. Malware category id
     * @return a WindowsMalwareCategory
     */
    @jakarta.annotation.Nullable
    public WindowsMalwareCategory getCategory() {
        return this.backingStore.get("category");
    }
    /**
     * Gets the deviceCount property value. Count of devices with malware detections for this malware category
     * @return a Integer
     */
    @jakarta.annotation.Nullable
    public Integer getDeviceCount() {
        return this.backingStore.get("deviceCount");
    }
    /**
     * Gets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
     * @return a Integer
     */
    @jakarta.annotation.Nullable
    public Integer getDistinctActiveMalwareCount() {
        return this.backingStore.get("distinctActiveMalwareCount");
    }
    /**
     * The deserialization information for the current model
     * @return a Map<String, java.util.function.Consumer<ParseNode>>
     */
    @jakarta.annotation.Nonnull
    public Map<String, java.util.function.Consumer<ParseNode>> getFieldDeserializers() {
        final HashMap<String, java.util.function.Consumer<ParseNode>> deserializerMap = new HashMap<String, java.util.function.Consumer<ParseNode>>(6);
        deserializerMap.put("activeMalwareDetectionCount", (n) -> { this.setActiveMalwareDetectionCount(n.getIntegerValue()); });
        deserializerMap.put("category", (n) -> { this.setCategory(n.getEnumValue(WindowsMalwareCategory::forValue)); });
        deserializerMap.put("deviceCount", (n) -> { this.setDeviceCount(n.getIntegerValue()); });
        deserializerMap.put("distinctActiveMalwareCount", (n) -> { this.setDistinctActiveMalwareCount(n.getIntegerValue()); });
        deserializerMap.put("lastUpdateDateTime", (n) -> { this.setLastUpdateDateTime(n.getOffsetDateTimeValue()); });
        deserializerMap.put("@odata.type", (n) -> { this.setOdataType(n.getStringValue()); });
        return deserializerMap;
    }
    /**
     * Gets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
     * @return a OffsetDateTime
     */
    @jakarta.annotation.Nullable
    public OffsetDateTime getLastUpdateDateTime() {
        return this.backingStore.get("lastUpdateDateTime");
    }
    /**
     * Gets the @odata.type property value. The OdataType property
     * @return a String
     */
    @jakarta.annotation.Nullable
    public String getOdataType() {
        return this.backingStore.get("odataType");
    }
    /**
     * Serializes information the current object
     * @param writer Serialization writer to use to serialize this model
     */
    public void serialize(@jakarta.annotation.Nonnull final SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("activeMalwareDetectionCount", this.getActiveMalwareDetectionCount());
        writer.writeEnumValue("category", this.getCategory());
        writer.writeIntegerValue("deviceCount", this.getDeviceCount());
        writer.writeIntegerValue("distinctActiveMalwareCount", this.getDistinctActiveMalwareCount());
        writer.writeOffsetDateTimeValue("lastUpdateDateTime", this.getLastUpdateDateTime());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeAdditionalData(this.getAdditionalData());
    }
    /**
     * Sets the activeMalwareDetectionCount property value. Count of active malware detections for this malware category. Valid values -2147483648 to 2147483647
     * @param value Value to set for the activeMalwareDetectionCount property.
     */
    public void setActiveMalwareDetectionCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("activeMalwareDetectionCount", value);
    }
    /**
     * Sets the AdditionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
     * @param value Value to set for the AdditionalData property.
     */
    public void setAdditionalData(@jakarta.annotation.Nullable final Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }
    /**
     * Sets the backingStore property value. Stores model information.
     * @param value Value to set for the backingStore property.
     */
    public void setBackingStore(@jakarta.annotation.Nonnull final BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }
    /**
     * Sets the category property value. Malware category id
     * @param value Value to set for the category property.
     */
    public void setCategory(@jakarta.annotation.Nullable final WindowsMalwareCategory value) {
        this.backingStore.set("category", value);
    }
    /**
     * Sets the deviceCount property value. Count of devices with malware detections for this malware category
     * @param value Value to set for the deviceCount property.
     */
    public void setDeviceCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("deviceCount", value);
    }
    /**
     * Sets the distinctActiveMalwareCount property value. Count of distinct active malwares for this malware category. Valid values -2147483648 to 2147483647
     * @param value Value to set for the distinctActiveMalwareCount property.
     */
    public void setDistinctActiveMalwareCount(@jakarta.annotation.Nullable final Integer value) {
        this.backingStore.set("distinctActiveMalwareCount", value);
    }
    /**
     * Sets the lastUpdateDateTime property value. The Timestamp of the last update for the device count in UTC
     * @param value Value to set for the lastUpdateDateTime property.
     */
    public void setLastUpdateDateTime(@jakarta.annotation.Nullable final OffsetDateTime value) {
        this.backingStore.set("lastUpdateDateTime", value);
    }
    /**
     * Sets the @odata.type property value. The OdataType property
     * @param value Value to set for the @odata.type property.
     */
    public void setOdataType(@jakarta.annotation.Nullable final String value) {
        this.backingStore.set("odataType", value);
    }
}
